<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Employee extends Model
{
    use SoftDeletes;
    use HasFactory;
    protected $fillable = [
        'company_id',
        'name',
        'role',
        'access',
        'key'
    ];

    const CheckIn = '0';
    const CheckOut = '1';

    protected static function boot()
    {
        parent::boot();
        static::creating(function ($employee) {
            $employee->key = random_int(100000, 999999);
        });
    }

    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id');
    }

    public function areas()
    {
        return $this->belongsToMany(Area::class, EmployeeArea::class);
    }

    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    public function employeeLogs()
    {
        return $this->hasMany(EmployeeLog::class);
    }
}
