<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Menu extends Model
{
    use SoftDeletes;
    use HasFactory;
    protected $fillable = [
        'menu_type_id',
        'company_id',
        'day',
        'from',
        'to'
    ];

    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id');
    }

    public function menuType()
    {
        return $this->belongsTo(MenuType::class, 'menu_type_id')
            ->select('id', 'company_id', 'name');
    }

    public function convertDay($day)
    {
        $days = [
            1 => 'Monday',
            2 => 'Tuesday',
            3 => 'Wednesday',
            4 => 'Thursday',
            5 => 'Friday',
            6 => 'Saturday',
            7 => 'Sunday',
        ];

        return $days[$day];
    }

    public function convertTime($from)
    {
        $fromarray = [
            0 => "12:00 am",
            1 => "01:00 am",
            2 => "02:00 am",
            3 => "03:00 am",
            4 => "04:00 am",
            5 => "05:00 am",
            6 => "06:00 am",
            7 => "07:00 am",
            8 => "08:00 am",
            9 => "09:00 am",
            10 => "10:00 am",
            11 => "11:00 am",
            12 => "12:00 pm",
            13 => "01:00 pm",
            14 => "02:00 pm",
            15 => "03:00 pm",
            16 => "04:00 pm",
            17 => "05:00 pm",
            18 => "06:00 pm",
            19 => "07:00 pm",
            20 => "08:00 pm",
            21 => "09:00 pm",
            22 => "10:00 pm",
            23 => "11:00 pm",
            24 => "12:00 pm",
        ];

        return date('h:i a',strtotime($from));
    }

    public function product()
    {
        return $this->hasOne(Product::class);
    }
}
