<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MenuType extends Model
{
    use SoftDeletes;
    use HasFactory;
    protected $fillable = [
            'company_id',
            'name'
    ];

    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id');
    }

    public function menus()
    {
        return $this->hasMany(Menu::class, 'id');
    }

    public function products(){
        return $this->hasMany(Product::class);
    }
}
