<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Option extends Model
{
    use SoftDeletes;
    use HasFactory;

    protected $fillable = [
        'company_id',
        'option_group_id',
        'product_price_id',
        'name',
        'price',
        'required',
        'check'
    ];

    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id');
    }

    public function companies()
    {
        return $this->belongsTo(Company::class, 'company_id');
    }

    public function optionGroup()
    {
        return $this->belongsTo(OptionGroup::class, 'option_group_id');
    }


}
