<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;


class OptionGroup extends Model
{
    use SoftDeletes;
    use HasFactory;

    protected $fillable = [
        'company_id',
        'name',
        'required',
        'check'
    ];

    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id');
    }

    public function companies()
    {
        return $this->belongsTo(Company::class, 'company_id');
    }

    public function options()
    {
        return $this->hasMany(Option::class);
    }

    public function customOptionNew()
    {
        return $this->belongsToMany(Option::class,ProductOption::class);
    }

    public function option_group()
    {
        return $this->belongsToMany(ProductPrice::class, 'options', 'option_group_id', 'product_price_id');
    }
}
