<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Log;
use Exception;

class Order extends Model
{
    use HasFactory, SoftDeletes;

    const STATUS_NEW = 0;
    const STATUS_PAID = 1;
    const STATUS_ASSIGNED = 2;
    const STATUS_CANCELED = 3;
    const STATUS_REFUND = 4;
    const STATUS_PARTIAL_REFUND = 5;

    const TYPE_DINE_IN = 0;
    const TYPE_TAKE_OUT = 1;
    const TYPE_RESERVATION = 2;
    const TYPE_DELIVERY = 3;

    protected $guarded = [];

    protected $casts = [
        'products' => 'array'
    ];

    public function setProductAttribute($value)
    {
        $properties = [];

        foreach ($value as $array_item) {
            if (!is_null($array_item['key'])) {
                $properties[] = $array_item;
            }
        }

        $this->attributes['products'] = json_encode($properties);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id');
    }

    public function area()
    {
        return $this->belongsTo(Area::class);
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function table()
    {
        return $this->belongsTo(Table::class);
    }
    //commit before moving add to add to cart API
    public function userOrders()
    {
        return $this->hasMany(UserOrder::class);
    }

    public function tip()
    {
        return $this->hasOne(Tip::class);
    }

    public function orderItems()
    {
        return $this->hasMany(OrderProducts::class, 'order_id');
    }

    public function orderProducts()
    {
        return $this->hasMany(OrderProduct::class);
    }

    public function reservation()
    {
        return $this->hasMany(Reservation::class);
    }

    public function splitEqual(int $number){
        if($number < 1 ||  $number > 10) throw new Exception('Split number ivalid');
        if($this->subtotal <=0 ) throw new Exception('Order subtotal should be greater than zero to split order');

        $this->userOrders()->notPaid()->delete();

        $subtotal = $this->subtotal / $number;

        for($i = 0; $i < $number; $i++){
            $userOrder = $this->userOrders()->create([
                'status' => UserOrder::STATUS_NEW,
                'company_id' => $this->company_id,
                'subtotal' => $subtotal
            ]);
            $userOrder->calculate();

            if(!$userOrder->tips) $userOrder->tips = $this->tips ?? 0;
            if(!$userOrder->tax) $userOrder->tax = $this->tax ?? 0;
            $userOrder->discount = 0;
            $userOrder->save();
        }
    }

    public function calculate(){
        foreach($this->userOrders as $userOrder){
            $userOrder->calculate();
            $userOrder->save();
        }
    }

    public function isPaid(){
        $paid = true;
        $this->unsetRelation('userOrders');
        foreach($this->userOrders as $userOrder){
            if(!$userOrder->isStatusPaid()) $paid = false;
        }
        return $paid;
    }

}
