<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderCode extends Model
{
    use HasFactory,SoftDeletes;

    protected $guarded = [];

    public function userPromo()
    {
        return $this->hasMany(UserPromo::class , 'order_code' , 'code');
    }

    public function promo()
    {
        return $this->belongsTo(Promo::class);
    }
}
