<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderProductGroupOptions extends Model
{
    use HasFactory;
    protected $table    = 'order_product_groupoptions';
    protected $guarded  = [];

    public function optionGroup()
    {
        return $this->belongsTo(OptionGroup::class,'option_group_id')->select('id','name','required','check');
    }
    public function option()
    {
        return $this->belongsTo(Option::class,'option_id')->select('id','name','price','required','check');
    }
    public function producOptionGroupOptions()
    {
        return $this->belongsTo(OptionGroup::class);
    }
}
