<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = [];

    protected $casts = [
        'options' => 'array',
        'prices' => 'array'
    ];

    public function productprice()
    {
        return $this->hasOne(ProductPrice::class);
    }

//    public function cusFF()
//    {
//        return $this->hasManyThrough(
//
//        );
//    }

    public function productSize()
    {
        return $this->belongsToMany(Size::class,ProductPrice::class);
    }

    public function productGroup()
    {
        return $this->hasManyThrough(ProductOptionGroup::class,ProductPrice::class);
    }

    public function customSize()
    {
        return $this->belongsToMany(Size::class, ProductPrice::class)->withPivot('price', 'id');
    }

    public function customGroup()
    {
        return $this->belongsToMany(OptionGroup::class, ProductOptionGroup::class)->withPivot('upto','is_required','size_id');
    }

    public function customOptions()
    {
        return $this->belongsToMany(Option::class, ProductOption::class);
    }

    public function menu()
    {
        return $this->belongsTo(Menu::class);
    }

    public function menutype()
    {
        return $this->belongsTo(MenuType::class, 'menu_type_id');
    }

    public function toppings()
    {
        return $this->hasMany(Topping::class);
    }

    public function options()
    {
        return $this->hasMany(Option::class);
    }

    public function productprices()
    {
        return $this->belongsToMany(Size::class, 'product_prices', 'product_id', 'size_id');
    }


    public function company(){
        return $this->belongsTo(Company::class);
    }

}
