<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Arr;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;

class Promo extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'opens_at' => 'datetime',
        'ended_at' => 'datetime',
        'services' => 'array',
        'price' => 'array'
    ];

    protected $table = 'promos';

    public function company()
    {
        return $this->belongsTo(Company::class, 'company_id');
    }

    public function types()
    {
        return $this->hasMany(PromoType::class);
    }

    public function userPromos()
    {
        return $this->hasMany(UserPromo::class);
    }

    public function service($key)
    {
        return Arr::get($this->services, $key);
    }

    public function url()
    {
        return '/promo/' . $this->id;
    }

    public function amountSum($refresh = false)
    {
        $key = "promo-$this->id-amount-sum";
        if (!$refresh && Cache::has($key)) return Cache::get($key);
        $sum = $this->userPromos()->completed()->sum('amount');
        Cache::put($key, $sum);
        return $sum;
    }

    public function totalSum($refresh = false)
    {
        $key = "promo-$this->id-total-sum";
        if (!$refresh && Cache::has($key)) return Cache::get($key);
        $sum = $this->userPromos()->completed()->sum('total');
        Cache::put($key, $sum);
        return $sum;
    }

    public function amountLeft()
    {
        $amount = $this->value - $this->amountSum() / 100;
        return $amount > 0 ? $amount : 0;
    }

    public function isActive()
    {
        return true; //$this->opens_at <= now() && now() <= $this->ended_at && $this->amountLeft() > 0; //return bool
    }

    public function statusHuman()
    {
        return $this->isActive()
            ? ('Deal ends in ' . $this->ended_at->diffForHumans())
            : ($this->hasStarted()
                ? 'Deal has completed'
                : 'Deal opens in ' . $this->opens_at->diffForHumans()
            );
    }

    public function hasStarted()
    {
        return $this->opens_at <= now();
    }

    public function remainingDays()
    {
        return $this->ended_at->diffForHumans();
    }
}
