<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, SoftDeletes;

    const TYPE_CUSTOMER = 0;
    const TYPE_BUSINESS = 1;
    const TYPE_ADMIN = 2;

    protected $fillable = [
        'name',
        'email',
        'password',
        'type',
        'phone_number',
        'first_name',
        'last_name',
        'facebook_id',
        'gmail_id',
        'email_verified_at',
        'phone_verified_at',
        'user_qrcode',
        'stripe_connect_id',
        'medical_card_no',
        'meddical_card_state',
        'caregiver_id_number',
        'medical_status',
        'photo',
        'photo_id',
        'date_of_birth',
        'medical_card_expiration',
    ];

    protected $hidden = [
        'password',
        'remember_token',
        'two_factor_recovery_codes',
        'two_factor_secret',
    ];

    protected $casts = [
        'date_of_birth' => 'date',
        'medical_card_expiration' => 'date',
        'email_verified_at' => 'datetime',
        'phone_verified_at' => 'datetime',
    ];

    // protected $appends = [
    //     'profile_photo_url',
    // ];




    // =======================================================================================================
    // Unknown code 
    // =======================================================================================================

    public function getUserQrcodeAttribute($value)
    {
        return "https://pickgo.nyc3.digitaloceanspaces.com/".$value;
    }

    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    public function userOrders()
    {
        return $this->hasMany(UserOrder::class);
    }

    public function userPromos()
    {
        return $this->hasMany(UserPromo::class);
    }

    // Get Complted user promo
    public function userCompletePromos()
    {
        return $this->hasMany(UserPromo::class)->where(function ($query) {
            $query->orWhere('status', UserPromo::STATUS_COMPLETED)
                ->orWhere('action', UserPromo::APPROVED);
        });
    }

    public function userClaims()
    {
        return $this->hasMany(UserClaim::class);
    }

    public function reservations()
    {
        return $this->hasMany(Reservation::class);
    }

    public function rewardCycle()
    {
        return $this->hasMany(RewardCycle::class);
    }

    public function transactions()
    {
        return $this->hasMany(Transaction::class);
    }

    public function userDiscount()
    {
        return $this->hasMany(UserDiscount::class);
    }

    public function usedDiscount()
    {
        return $this->hasMany(UsedDiscounts::class);
    }

    public function companies()
    {
        return $this->hasMany(Company::class, 'owner_id', 'id');
    }

    // this relation is incorrect and should be concidered to fix
    public function company()
    {
        return $this->hasOne(Company::class, 'owner_id', 'id');
    }

    public function anyName()
    {
        return $this->name ?: $this->email ?: $this->phone_number;
    }

    public static function check($user = null)
    {
        if (!empty($user) && is_numeric($user)) {
            return $user = User::findOrFail($user);
        }
        return null;
    }

    public function file()
    {
        return $this->morphMany(File::class, 'fileable');
    }

    public function logoUrl()
    {
        return $this->file()->exists()
            ? asset('storage/' . $this->file()->first()->name)
            : 'https://www.gravatar.com/avatar/' . md5(strtolower(trim($this->email)));
    }

    public function coverImageUrl()
    {
        return auth()->user()->company->file()->exists()
        ? asset('storage/' . auth()->user()->company->file()->first()->name)
        : 'https://www.gravatar.com/avatar/' . md5(strtolower(trim($this->email)));
        // return  $this->file()->exists()
        //     ? asset('storage/' . auth()->user()->company->file()->first()->name)
        //     : 'https://www.gravatar.com/avatar/' . md5(strtolower(trim($this->email)));
    }

    public static function types()
    {
        return [
            self::TYPE_CUSTOMER => 'Customer',
            self::TYPE_BUSINESS => 'Business Owner',
            self::TYPE_ADMIN => 'Admin',
        ];
    }

    public function isSuperAdmin()
    {
        return $this->type == self::TYPE_ADMIN;
    }

    public function isAdmin()
    {
        return $this->type == self::TYPE_ADMIN || $this->type == self::TYPE_ADMIN;
    }

    public function isCustomer()
    {
        return $this->type == self::TYPE_CUSTOMER;
    }

    public function isBusiness()
    {
        return $this->type == self::TYPE_BUSINESS;
    }

    public function isPhoneVerified()
    {
        return $this->phone_verified_at != null;
    }

    public function scopeByEmail($query, $email)
    {
        return $query->where('email', $email);
    }

    public function scopeByPhone($query, $phone)
    {
        return $query->where('phone_number', $phone);
    }

    public function scopeCustomer($query)
    {
        return $query->where('type', self::TYPE_CUSTOMER);
    }

    public function routeNotificationForVonage($notification)
    {
        return $this->phone_number;
    }

    // Deprecated, use userPromos() instead
    public function user_promo()
    {
        return $this->userPromos();
    }

    public static function by($data)
    {
        $user = null;
        $name = Arr::get($data, 'name');
        $email = Arr::get($data, 'email');
        $phone = Arr::get($data, 'phone_number');
        $first_name = $data["first_name"] ?? "";
        $last_name = $data["last_name"] ?? "";
        if (!$name && $email) $name = ucfirst(strstr($email, '@', true));
        if (!$user && $email) $user = self::byEmail($email)->first();
        if (!$user && $phone) $user = self::byPhone($phone)->first();
        if (!$user && ($email || $phone)) {
            $password = bcrypt(Arr::get($data, 'password', Str::random(40)));
            $user = new self();
            $user->name = $name;
            $user->first_name = $first_name;
            $user->last_name = $last_name;
            $user->email = $email;
            $user->phone_number = $phone;
            $user->type = self::TYPE_CUSTOMER;
            $user->password = $password;
            $user->save();
        }
        return $user;
    }
    
}
