<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserClaim extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = "user_claims";
    protected $casts = [
        'user_id' => 'integer',
        'amount' => 'integer',
        'claim_id' => 'integer'
    ];
    protected $guarded = [];

    protected $fillable = [
        'user_id',
        'amount',
        'claim_id',
        'company_id'
];


public function user()
{
    return $this->belongsTo(User::class);
}
}
