<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;

class UserPromo extends Model
{
    use HasFactory;

    const STATUS_NEW = 'new';
    const STATUS_PROCESSING = 'processing';
    const STATUS_COMPLETED = 'completed';

    const APPROVED = 'Approved';
    const DISAPPROVED = 'Disapprove';
    const PENDING = 'Pending';
    
    protected $table = 'user_promo';

    protected $guarded = []; 

    public function promo()
    {
        return $this->belongsTo(Promo::class, 'promo_id');
    }

    public function promoType()
    {
        return $this->belongsTo(PromoType::class, 'promo_type_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function transaction()
    {
        return $this->belongsTo(Transaction::class, 'transaction_id', 'id');
    }

    public function promoUses()
    {
        return $this->hasMany(PromoUse::class);
    }

    public function scopeCompleted($query){
        return $query->where('status', self::STATUS_COMPLETED);
    }

    public function getAmountUsedAttribute(){
        return $this->promoUses()->sum('amount');
    }

    public function getAmountAvailableAttribute(){
        return $this->amount - $this->amount_used;
    }

    public static function from(array $fields){

        extract($fields);

        $user = null;

        if(!$phone_number && !$email){
            return throw new \Exception('Email or Phone Number should be set');
        }

        if(!$amount){
            return throw new \Exception('Amount is not set');
        }

        if(!$type){
            return throw new \Exception('Type is not set');
        }

        if(!$user && $phone_number){
            $user = User::where('phone_number', trim($phone_number))->first();
        }

        if($user && $email && $user->email != trim($email)){
            return throw new \Exception('User with the ' . $phone_number . ' does not have following email address: ' . $email);
        }

        if(!$user && $email){
            $user = User::where('email', trim($email))->first();
        }

        if(!$user){
            $user = User::create([
                'email' => $email,
                'first_name' => $first_name,
                'last_name' => $last_name,
                'phone_number' => $phone_number,
            ]);
        }

        $promoType = $promo_type ? PromoType::find($promo_type) : null;

        $userPromo = UserPromo::create([
            'promo_id' => $promo,
            'promo_type_id' => $promo_type,
            'user_id' => $user->id,
            'amount' => $amount * 100,
            'taxes' => 0,
            'total' => $promoType ? ($promoType->totalBy($amount) * 100) : ($amount * 100),
            'status' => UserPromo::STATUS_COMPLETED,
            'company_id'=> session()->get('pageid') ? session()->get('pageid'):0
        ]);
        self::updateInsummary($userPromo);
    }

//    protected static function booted()
//    {
//        static::created(function ($user_promo) {
//            error_reporting(0);
//            if($user_promo->status == UserPromo::STATUS_COMPLETED && ( is_null($user_promo->action) || $user_promo->action == UserPromo::APPROVED)){
//                if(!is_null($user_promo->company_id) && $user_promo->company_id > 0){
//                    $company_id = $user_promo->company_id;
//                }else{
//                    $promo      =  Promo::find($user_promo->promo_id);
//                    $company_id =  $promo ? (int)$promo->company_id : 0;
//                }
//                $gcSummary  =  GiftCardSummary::where('user_id',$user_promo->user_id)->where('company_id',$company_id)->first();
//                if($gcSummary){
//                    $gcSummary->total_balance = $gcSummary->total_balance + ($user_promo->amount >  0 ? $user_promo->amount/100 : 0);
//                }else{
//                    $gcSummary                  =   new GiftCardSummary();
//                    $gcSummary->user_id         =   $user_promo->user_id;
//                    $gcSummary->company_id      =   $company_id;
//                    $gcSummary->total_balance   =   $user_promo->amount >  0 ? $user_promo->amount/100 : 0;
//                }
//                $gcSummary->save();
//                UserPromo::where('id',$user_promo->id)->update(['added_to_total'=>'yes']);
//            }
//
//        });
//    }
    public static function  updateInsummary($user_promo){
        Log::info("Yes".json_encode($user_promo));
        if(!$user_promo->added_to_total || $user_promo->added_to_total != 'yes'){
            if(!is_null($user_promo->company_id) && $user_promo->company_id > 0){
                $company_id = $user_promo->company_id;
            }else{
                $promo      =  Promo::find($user_promo->promo_id);
                $company_id =  $promo ? (int)$promo->company_id : 0;
            }
            $gcSummary  =  GiftCardSummary::where('user_id',$user_promo->user_id)->where('company_id',$company_id)->first();
            if($gcSummary){
                $gcSummary->total_balance = $gcSummary->total_balance + ($user_promo->amount >  0 ? $user_promo->amount/100 : 0);
            }else{
                $gcSummary                  =   new GiftCardSummary();
                $gcSummary->user_id         =   $user_promo->user_id;
                $gcSummary->company_id      =   $company_id;
                $gcSummary->total_balance   =   $user_promo->amount >  0 ? $user_promo->amount/100 : 0;
            }
            $gcSummary->save();
            UserPromo::where('id',$user_promo->id)->update(['added_to_total'=>'yes']);
        }
    }
}
