<?php

namespace App\Nova;

use Illuminate\Http\Request;
use Laravel\Nova\Fields\ID;
use Laravel\Nova\Fields\BelongsTo;
use Laravel\Nova\Fields\Number;
use Laravel\Nova\Fields\Text;
use Laravel\Nova\Fields\DateTime;
use Laravel\Nova\Fields\HasMany;
use Laravel\Nova\Fields\Select;
use Laravel\Nova\Http\Requests\NovaRequest;
use Devtical\Qrcode\Qrcode;
use App\Nova\Promo;



class OrderCode extends Resource
{
    /**
     * The model the resource corresponds to.
     *
     * @var string
     */
    public static $model = \App\Models\OrderCode::class;
    public static $group = 'Other';

    /**
     * The single value that should be used to represent the resource when being displayed.
     *
     * @var string
     */
    public static $title = 'id';

    /**
     * The columns that should be searched.
     *
     * @var array
     */
    public static $search = [
        'id',
    ];

    /**
     * Get the fields displayed by the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function fields(NovaRequest $request)
    {
        return [
            ID::make()->sortable(),
            Text::make('code')->rules('required'),
            BelongsTo::make('Location', 'promo', Promo::class)->rules('required')->withOutTrashed()->resolveUsing(function ($value, $resource, $attribute) {
                return $resource->promo()->where('company_id', 1)->first();
            })->display(function ($promo) {
                return $promo->address;
            }),

            Text::make('amount')->rules('required'),
            Select::make('Restaurant Type', 'restaurant_type')->options([
                'groupon' => "Groupon",
                'restaurant' => "Restaurant.com",
                'other' => "Other"
            ])->rules('required'),//
//            Qrcode::make('QR Code','code',function(){
//                return "['code' => $this->code,'amount' => $this->amount, 'promo' => $this->promo_id,'restaurant_type' => $this->restaurant_type]";
//            })->indexSize(100)
//           ->detailSize(500),
            Qrcode::make('QR Code','code',function(){
                return route('download.app')."?type=ordercode&id={$this->code}&code={$this->code}&amount={$this->amount}&promo={$this->promo_id}&restaurant_type={$this->restaurant_type}";
//                return "['code' => $this->code,'amount' => $this->amount, 'promo' => $this->promo_id,'restaurant_type' => $this->restaurant_type]";
            })->indexSize(100)
                ->detailSize(500),
            Text::make('Created at', 'created_at', function () { 
                return sprintf('%s',$this->created_at->format('d M Y'));
              })->showOnIndex()
                ->showOnDetail()
                ->hideWhenCreating()
                ->hideWhenUpdating(),
  
              Text::make('Updated at', 'updated_at', function () { 
                return sprintf('%s',$this->updated_at->format('d M Y'));
              })->showOnIndex()
                ->showOnDetail()
                ->hideWhenCreating()
                ->hideWhenUpdating(),
            HasMany::make('UserPromo'),
        ];
    }

    /**
     * Get the cards available for the request.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function cards(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the filters available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function filters(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the lenses available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function lenses(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the actions available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function actions(NovaRequest $request)
    {
        return [];
    }
}
