<?php

namespace App\Nova;

use Laravel\Nova\Fields\ID;
use Illuminate\Http\Request;
use Laravel\Nova\Fields\Text;
use Laravel\Nova\Fields\Number;
use Laravel\Nova\Fields\Select;
use Laravel\Nova\Fields\BelongsTo;
use Laravel\Nova\Http\Requests\NovaRequest;

class OrderProduct extends Resource
{
    /**
     * The model the resource corresponds to.
     *
     * @var string
     */
    public static $model = \App\Models\OrderProduct::class;

    /**
     * The single value that should be used to represent the resource when being displayed.
     *
     * @var string
     */
    public static $title = 'Order Product';

    public static $group = 'Orders';
    /**
     * The columns that should be searched.
     *
     * @var array
     */
    public static $search = [
        'id', 'user', 'product',
    ];

    /**
     * Get the fields displayed by the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function fields(NovaRequest $request)
    {
        return [
            ID::make()->sortable(),
            BelongsTo::make('order')->searchable()->rules('required'),
            //need to update when 'employee' table will be created
            Text::make('Employee', 'employee_id')->withMeta([
                'extraAttributes' => [
                    'placeholder' => 'Employee Id will be here',
                ],
            ])->rules('required'),
            BelongsTo::make('user')->searchable()->rules('required')->onlyOnIndex(),
            Select::make('User', 'user_id')->options(\App\Models\User::pluck('name', 'id'))->searchable()->rules('required')->hideFromIndex(),

            //need to update when 'product' table will be created
            Text::make('Product', 'product_id')->withMeta([
                'extraAttributes' => [
                    'placeholder' => 'Product Id will be here',
                ],
            ])->rules('required'),

            //need to update when 'product_price_id' table will be created
            Text::make('Product Price Id', 'product_price_id')->withMeta([
                'extraAttributes' => [
                    'placeholder' => 'Product Price Id will be here',
                ],
            ])->rules('required'),
            //need to update when 'size_id' table will be created
            Text::make('Size Id', 'size_id')->withMeta([
                'extraAttributes' => [
                    'placeholder' => 'Size Id will be here',
                ],
            ])->rules('required'),

            Text::make('Products', 'products')->rules('required'),

            Number::make('amount')->min(1)->rules('required'),

            Number::make('price')->min(1)->rules('required'),
        ];
    }

    /**
     * Get the cards available for the request.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function cards(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the filters available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function filters(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the lenses available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function lenses(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the actions available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function actions(NovaRequest $request)
    {
        return [];
    }
}
