<?php

namespace App\Nova;

use Illuminate\Http\Request;
use Laravel\Nova\Fields\ID;
use Laravel\Nova\Fields\Place;
use Laravel\Nova\Fields\Number;
use Laravel\Nova\Fields\Text;
use Laravel\Nova\Fields\Date;
use Laravel\Nova\Fields\DateTime;
use Laravel\Nova\Fields\Textarea;
use Laravel\Nova\Fields\Select;
use Laravel\Nova\Fields\BelongsTo;
use Laravel\Nova\Fields\BooleanGroup;
use Laravel\Nova\Fields\Code;
use Laravel\Nova\Http\Requests\NovaRequest;
use Laravel\Nova\Fields\HasMany;
use Laravel\Nova\Panel;
use Str;

class Promo extends Resource
{
    /**
     * The model the resource corresponds to.
     *
     * @var string
     */
    public static $model = \App\Models\Promo::class;


    /**
     * The single value that should be used to represent the resource when being displayed.
     *
     * @var string
     */
    public static $title = 'address';

    public static $group = 'Gift Cards';
    public static function label(){ return 'Gift Cards'; }

    /**
     * The columns that should be searched.
     *
     * @var array
     */
    public static $search = [
        'title',
    ];

    /**
     * Get the fields displayed by the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */

     public static function indexQuery(NovaRequest $request, $query)
     {
        return $query->Where('company_id', auth()->user()->company?->id);
     }

    public function fields(NovaRequest $request)
    {
        return [

            ID::make()->sortable(),

            Place::make('Location', 'address')->onlyOnIndex()->resolveUsing(fn ($item) => Str::limit($item, 25)),

            Place::make('Location', 'address')->rules('required')->hideFromIndex(),

            BelongsTo::make('Company', 'company', 'App\Nova\Company')->searchable()->rules('required')->withOutTrashed(),

            Textarea::make('Description', 'description'),

            Number::make('Value Amount', 'value')->rules('required')->help('Dollars'),

            Code::make('Price', 'price')->rules('required', function ($attribute, $value, $fail) {
                json_decode($value);
                if (json_last_error() !== JSON_ERROR_NONE) {
                    return $fail('The options field should be a valid JSON string.');
                }
            })->json()->help('Array of prices in dollars. Example: [ 100, 200, 300 ]'),

            Select::make('Status')->options([
                0 => 'Coming Soon',
                1 => 'Now Open',
            ])->displayUsing(fn ($value) => $value == 0 ? "Coming Soon" : "Now Open"),

            Date::make('Opens At', 'opens_at'),

            Date::make('Ended At', 'ended_at'),

            BooleanGroup::make('Services')->options([
                'terrace_plaza' => 'In The Terrace Plaza',
                'dine_in' => 'Dine in',
                'curbside_pickup' => 'Curbside pickup',
                'no_delivery' => 'No delivery',
                'take_away' => 'Take Away',
            ]),

            new Panel('Summary', $this->summary()),

            HasMany::make('Types', 'types', PromoType::class),

            HasMany::make('User Promos')
        ];
    }

    public function summary()
    {
        return [
            Text::make('Value Amount', fn () => '$' . number_format($this->value, 2))->hideFromIndex(),
            Text::make('Amount Sum', fn () => '$' . number_format($this->amountSum() / 100, 2))->hideFromIndex(),
            Text::make('Total Sum (how much they paid)', fn () => '$' . number_format($this->totalSum() / 100, 2))
                ->hideFromIndex(),
            Text::make('Left', fn () => '$' . number_format($this->amountLeft(), 2))
                ->hideFromIndex(),
            Text::make('Status', fn () => $this->statusHuman())->hideFromIndex()

        ];
    }

    /**
     * Get the cards available for the request.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function cards(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the filters available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function filters(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the lenses available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function lenses(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the actions available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function actions(NovaRequest $request)
    {
        return [];
    }
}
