<?php

namespace App\Nova;

use Illuminate\Http\Request;
use Laravel\Nova\Fields\ID;
use Laravel\Nova\Fields\BelongsTo;
use Laravel\Nova\Fields\Text;
use Laravel\Nova\Fields\Textarea;
use Laravel\Nova\Fields\Number;
use Laravel\Nova\Fields\Select;
use Laravel\Nova\Fields\HasMany;
use Laravel\Nova\Fields\File;
use Laravel\Nova\Fields\Image;
use Illuminate\Support\Facades\Storage;
use Laravel\Nova\Http\Requests\NovaRequest;
use Laravel\Nova\Panel;
use App\Models\PromoType as PromoTypeModel;

class PromoType extends Resource
{
    /**
     * The model the resource corresponds to.
     *
     * @var string
     */
    public static $model = \App\Models\PromoType::class;

    public static $group = 'Gift Cards';
    public static function label(){ return 'Types'; }

    /**
     * The single value that should be used to represent the resource when being displayed.
     *
     * @var string
     */
    public static $title = 'title';

    /**
     * The columns that should be searched.
     *
     * @var array
     */
    public static $search = [
        'id', 'title',
    ];

    public static $displayInNavigation = false;

    /**
     * Get the fields displayed by the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function fields(NovaRequest $request)
    {
        return [
            ID::make()->sortable(),
            BelongsTo::make('Promo', 'promo', 'App\Nova\Promo')->searchable(),
            Select::make('Type', 'type')->options([
                PromoTypeModel::TYPE_DISCOUNT => 'Advantage',
                PromoTypeModel::TYPE_HOMELESS => 'Claim',
                PromoTypeModel::TYPE_SCHOOL => 'Third party',
                PromoTypeModel::TYPE_COMMUNITY => 'Regular',
                PromoTypeModel::TYPE_SOMEONE => 'For Someone',
                PromoTypeModel::TYPE_OTHER => 'Manuallay'
            ]),
            Text::make('Title', 'title'),
            Textarea::make('Description', 'description'),
            Select::make('Discount')->options([
                0 => '0%',
                10 => '10%',
                20 => '20%',
                30 => '30%',
                40 => '40%',
                50 => '50%',
                60 => '60%',
                70 => '70%',
                80 => '80%',
                90 => '90%',
            ])->rules('required')->displayUsing(fn($value) => $value . '%'),
           Image::make('Files','files')->disk(config('filesystems.default'))->path('public/promo-type'),

            new Panel('Summary', $this->summary()),

            HasMany::make('User Promos')
        ];
    }

    public function summary(){
        return [
            Number::make('Sold', 'sold')->rules('required'),
            Text::make('Amount Sum', fn() => '$' . number_format($this->amountSum() / 100, 2))->hideFromIndex(),
            Text::make('Total Sum (how much they paid)', fn() => '$' . number_format($this->totalSum() / 100, 2))
                ->hideFromIndex(),
        ];
    }

    /**
     * Get the cards available for the request.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function cards(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the filters available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function filters(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the lenses available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function lenses(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the actions available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function actions(NovaRequest $request)
    {
        return [ new Actions\GiftCard()];
    }
}
