<?php

namespace App\Nova;

use Laravel\Nova\Fields\ID;
use Illuminate\Http\Request;
use Laravel\Nova\Fields\Text;
use Laravel\Nova\Fields\Number;
use Laravel\Nova\Fields\Select;
use Laravel\Nova\Fields\DateTime;
use Laravel\Nova\Fields\BelongsTo;
use Laravel\Nova\Http\Requests\NovaRequest;

class Reservation extends Resource
{
    /**
     * The model the resource corresponds to.
     *
     * @var string
     */
    public static $model = \App\Models\CustomerReservations::class;

    /**
     * The single value that should be used to represent the resource when being displayed.
     *
     * @var string
     */
    public static $title = 'Reservation';

    /**
     * The columns that should be searched.
     *
     * @var array
     */
    public static $search = [
        'id',
    ];

    /**
     * Get the fields displayed by the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function fields(NovaRequest $request)
    {
        return [
            ID::make()->sortable(),
            BelongsTo::make('user')->searchable()->rules('required')->onlyOnIndex(),
            Select::make('User', 'user_id')->options(\App\Models\User::pluck('name', 'id'))->searchable()->rules('required')->hideFromIndex(),
            BelongsTo::make('order')->searchable()->rules('required'),
            BelongsTo::make('company')->searchable()->rules('required')->onlyOnIndex(),
            Select::make('Company', 'company_id')->options(\App\Models\Company::pluck('name', 'id'))->searchable()->rules('required')->hideFromIndex(),


            //need to update when 'table' table will be created
            Text::make('Table Id', 'table_id')->withMeta([
                'extraAttributes' => [
                    'placeholder' => 'Table Id will be here',
                ],
            ])->rules('required'),

//            Text::make('Type')->rules('required'),

            DateTime::make('Date Time', 'datetime')->rules('required'),
//            DateTime::make('Ends At', 'ends_at')->rules('required'),

            Number::make('Party Size','party_size')->min(1)->rules('required'),
            Text::make('Notes', 'notes'),

            //need to update when 'employee' table will be created
//            Text::make('Employee', 'employee_id')->withMeta([
//                'extraAttributes' => [
//                    'placeholder' => 'Employee Id will be here',
//                ],
//            ])->rules('required'),

            //need to update when 'employee' table will be created
//            Text::make('Charge Id', 'charge_id')->withMeta([
//                'extraAttributes' => [
//                    'placeholder' => 'Charge Id will be here',
//                ],
//            ])->rules('required'),
        ];
    }

    /**
     * Get the cards available for the request.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function cards(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the filters available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function filters(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the lenses available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function lenses(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the actions available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function actions(NovaRequest $request)
    {
        return [];
    }
}
