<?php

namespace App\Nova;

use Laravel\Nova\Fields\ID;
use Illuminate\Http\Request;
use Laravel\Nova\Fields\Text;
use Laravel\Nova\Fields\Select;
use Laravel\Nova\Fields\Currency;
use Laravel\Nova\Fields\BelongsTo;
use Laravel\Nova\Fields\DateTime;
use Laravel\Nova\Http\Requests\NovaRequest;
use Vyuldashev\NovaMoneyField\Money;
use App\Models\Transaction as TransactionModel;

class Transaction extends Resource
{
    /**
     * The model the resource corresponds to.
     *
     * @var string
     */
    public static $model = \App\Models\Transaction::class;

    /**
     * The single value that should be used to represent the resource when being displayed.
     *
     * @var string
     */
    public function title()
    {
        return 'Transaction #' . $this->id;
    }

    /**
     * The columns that should be searched.
     *
     * @var array
     */
    public static $search = [
        'id',
    ];

    /**
     * Get the fields displayed by the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function fields(NovaRequest $request)
    {
        return [
            ID::make()->sortable(),
            // BelongsTo::make('User Order', 'userOrder', UserOrder::class)->searchable(),
            BelongsTo::make('User Promo', 'userPromo', UserPromo::class)->searchable(),
            Select::make('Type')->options([
                TransactionModel::TYPE_GIFT_CARD => 'Payment using gift Card',
                TransactionModel::TYPE_UO_TERMINAL => 'In person payment (terminal)',
                TransactionModel::TYPE_UO_CASH => 'Payment using Cash',
                TransactionModel::TYPE_UO_CARD => 'Payment using Card',
                TransactionModel::PROMO_USE => 'using gift Card to pay',
            ])->displayUsingLabels(),
            Select::make('Is Payout')->options([
                TransactionModel::IS_PAYOUT => 'Yes',
                0 => 'Pending'
            ])->displayUsingLabels(),
            BelongsTo::make('Employee'),
            BelongsTo::make('user')->searchable(),
            Text::make('Charge Id'),
            Text::make('Payment Intent Id'),
            Money::make('Amount')->storedInMinorUnits(),
            Money::make('Change')->storedInMinorUnits(),
            DateTime::make('Created At')->sortable(),
            DateTime::make('Updated At')->sortable()->hideFromIndex(),
            DateTime::make('Deleted At')->sortable()->hideFromIndex()
        ];
    }

    /**
     * Get the cards available for the request.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function cards(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the filters available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function filters(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the lenses available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function lenses(NovaRequest $request)
    {
        return [];
    }

    /**
     * Get the actions available for the resource.
     *
     * @param  \Laravel\Nova\Http\Requests\NovaRequest  $request
     * @return array
     */
    public function actions(NovaRequest $request)
    {
        return [];
    }
}
