<?php

namespace App\Repositories;

use App\Models\Discount;
use App\Models\UsedDiscounts;
use App\Models\UsedGlobalDiscount;
use App\Models\User;
use App\Models\UserDiscount;
use App\Models\UserGlobalDiscount;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use Laravel\Nova\Fields\Boolean;

class DiscountClaimRepository
{
    public function getActiveDiscount($company_id)
    {

        $active_discount = Discount::where('starts_at', '<=', Carbon::now())
            ->where('company_id',$company_id)
            ->first();


        return $active_discount;

    }


    public function isAbleToCreateNewDiscount($active_discount, $user,$company_id)
    {
        $max_users    = $active_discount->max_users;
        $total_users  = UserDiscount::where('id', $active_discount->discount_id)->where('company_id',$company_id)->where('user_id', $user->id)->groupBy('user_id')->count();
        return $max_users > $total_users ? true : false;
    }

    /**
     *
     * Return true, if the user can claim
     *
     * @param  User $user
     * @return Bool
     *
     */
    public function canClaim(User $user,$company_id): Bool
    {
        if($user){
            $discount = $this->getActiveDiscount($company_id);

            if (empty($discount)) {
                return false;
            }
            $total_claims = UserDiscount::where('discount_id', $discount->id)->where('company_id', $company_id)->count();

            if($total_claims >= $discount->total_no_of_discounts ){
                return false;
            }
            $user_has_discount = UserDiscount::where('user_id', $user->id)->where('company_id', $company_id)->where('discount_id', $discount->id)->get();
            if ($user_has_discount->isNotEmpty()) {
                $total_discount_entry = $user_has_discount->count();
                $total_used_amount    = UsedDiscounts::whereIn('user_discount_id', $user_has_discount->pluck('id'))->where('company_id', $company_id)->where('user_id', $user->id)->sum('amount');
                if (($total_used_amount) >= ($discount->amount * $total_discount_entry)) {
                    if ($this->isAbleToCreateNewDiscount($discount, $user,$company_id)) {
                        return true;
                    }
                }
            } else {
                return true;
            }
        }
        return false;
    }

    /**
     *
     * Create the user claim
     *
     * @param  User $user
     * @return void
     *
     */
    public function createClaim(User $user,$company_id, $global_discount=false)
    {
        $discount = $this->getActiveDiscount($company_id);
        if (empty($discount)) {
            return false;
        }

        if ($this->canClaim($user,$company_id)) {
            $user_discount = new UserDiscount();
            $user_discount->credit_amount = $discount->amount;
            $user_discount->company_id = $company_id;
            $user_discount->discount_id = $discount->id;
            $user_discount->user_id = $user->id;
            $user_discount->discount = json_encode($discount);
            $user_discount->is_global = $global_discount;
            $user_discount->save();
            return true;
        }
        return false;
    }

    public function createUsedDiscountEntry(User $user , $order_id , $discount_amount,$company_id)
    {
        $discount = $this->getActiveDiscount($company_id);

        if (empty($discount)) {
            return false;
        }

        $user_discount = UserDiscount::where('user_id', $user->id)->where('company_id', $company_id)->where('discount_id', $discount->id)->orderBy('id','DESC')->first();
        $use_discount = new UsedDiscounts();

        // $use_discount->user_order_id    =   $user_order_id;
        $use_discount->order_id         =   $order_id;
        $use_discount->company_id       =   $company_id;
        $use_discount->user_id          =   $user->id;
        $use_discount->user_discount_id =   $user_discount?->id;
        $use_discount->amount           =   $discount_amount;
        $use_discount->used_at          =   Carbon::now();
        $use_discount->save();
    }

    public function isPrizeTime($discount){
        // date_default_timezone_set("America/Los_Angeles");
        $startsAt = strtotime($discount->pt_starts_at);
        $endsAt = strtotime("+$discount->pt_total_hours hours", $startsAt);

        if($discount->pt_type == "prize_hour"){

            $dayNumber = date('N', strtotime('now'));
            $disHour = $discount->discount_hours()->where("day", $dayNumber)->first();
            if(!$disHour){
                $disHour = $discount->discount_hours()->where("day", ">" ,$dayNumber)->orderBy('day', 'asc')->first();
                if(!$disHour){
                    $disHour = $discount->discount_hours()->where("day", "<" ,$dayNumber)->orderBy('day', 'asc')->first();
                }
            }

            $startsAt = $disHour?->starts_at ?  strtotime(strftime("%F") . ' ' .$disHour->starts_at) : null;
            $endsAt = $disHour?->ends_at ?  strtotime(strftime("%F") . ' ' .$disHour->ends_at) : null;

        }

        if(time() >= $startsAt && time() <= $endsAt){
            return true;
        }

        return false;
    }

    /**
     *
     * Create the user claim
     *
     * @param  User $user
     * @return void
     *
     */
    public function discountAmount(User $user , $order_amount,$company_id)
    {
        $discount = $this->getActiveDiscount($company_id);

        if (empty($discount)) {
            return 0;
        }

        if( $this->isPrizeTime($discount) ){
            $discount_value   =  $discount->pt_percentage;
            $discount_amount  = ($order_amount * $discount_value) / 100;
        }else{
            $discount_value   =  $discount->terms;
            $discount_amount  = ($order_amount * $discount_value) / 100;
        }

        if($discount->max_discount_per_order){
            $discount_amount  = $discount_amount > $discount->max_discount_per_order ? $discount->max_discount_per_order : $discount_amount ;
        }
        // $remaing_discount_value = $this->remaingDiscountAmount($user , $discount,$company_id);

        // if ($remaing_discount_value <= 0) {
        //     return 0;
        // }
        // if ($remaing_discount_value <= $discount_amount) {
        //     return (float)$remaing_discount_value;
        // }
        return (float)$discount_amount;
    }

    public function remaingDiscountAmount(User $user , $discount,$company_id)
    {
        $user_has_discount = UserDiscount::where('user_id', $user->id)->where('company_id', $company_id)->where('discount_id', $discount->id)->get();
        if ($user_has_discount->isNotEmpty()) {
            $total_discount_entry = $user_has_discount->count();
            $total_used_amount    = UsedDiscounts::where('company_id', $company_id)->whereIn('user_discount_id', $user_has_discount->pluck('id'))->where('user_id', $user->id)->sum('amount');
            return ($discount->amount * $total_discount_entry) - $total_used_amount;
//            return $discount->amount - $total_used_amount;
        }
        return 0;
    }
    public function createDiscount($user_id,$order){
        if($order->discount > 0 ){
            $useed_discount =   UsedDiscounts::where('order_id',$order->id)->first();
            if(!$useed_discount){
                $user   =   User::where('id',$user_id)->first();
                $this->createUsedDiscountEntry($user , $order->id , $order->discount,$order->company_id);
            }
        }

    }

    public function remainginGlobalCredit($user_id){

        $user_credit = UserGlobalDiscount::where('user_id', $user_id)->sum("credit_amount");
        $used_discount = UsedGlobalDiscount::where('user_id', $user_id)->sum("used_amount");
        $user_credit = $user_credit ?: 0;
        $used_discount = $used_discount ?: 0;
        return $user_credit - $used_discount;
    }

    public function createGlobalUsedDiscountEntry(User $user , $order_id , $discount_amount,$company_id)
    {
        $discount = $this->getActiveDiscount($company_id);
        if (empty($discount)) {
            return false;
        }

        // $user_discount = UserDiscount::where('user_id', $user->id)->where('company_id', $company_id)->where('discount_id', $discount->id)->orderBy('id','DESC')->first();
        $use_discount = new UsedGlobalDiscount();

        // $use_discount->user_order_id    =   $user_order_id;
        $use_discount->order_id         =   $order_id;
        $use_discount->company_id       =   $company_id;
        $use_discount->user_id          =   $user->id;
        $use_discount->used_amount           =   $discount_amount;
        $use_discount->save();
    }
}
