<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class ProductSizeRule implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $sizes = json_decode($value);

        if(request('option_type') == "size"){

            if(count($sizes) <= 0) $fail("Please Fillup the group details");

            foreach ($sizes as $size) {
                foreach ($size->groups as $group) {
                    if(!$size->size || !$size->price || !$group->group || !$group->upto) {
                        $fail("Please Fillup the size details");
                    }
                }
            }
        }
    }
}
