<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->tinyInteger('type')->default(0);
            $table->boolean("is_admin")->default(0);
            $table->string('name');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('phone_number')->nullable();
            $table->timestamp('phone_verified_at')->nullable();
            $table->string('password')->nullable();
            $table->string("address" )->nullable();

            // unknown columns =======================
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('profile_photo_path', 2048)->nullable();
            $table->text('two_factor_secret')->nullable();
            $table->text('two_factor_recovery_codes')->nullable();
            $table->timestamp('two_factor_confirmed_at')->nullable();
            $table->foreignId('current_team_id')->nullable();
            $table->string('facebook_id')->nullable();
            $table->string('gmail_id')->nullable();
            $table->string('user_qrcode')->nullable();
            $table->string('stripe_connect_id')->nullable();
            $table->string("business_phone")->nullable();
            $table->integer("business_verified")->nullable();
            $table->dateTime('verified_agreement_at')->nullable()->default(null);
            $table->date('date_of_birth')->nullable()->default(null);
            $table->string('photo_id')->nullable()->default(null);
            $table->string('photo')->nullable()->default(null);
            $table->string('medical_card_no')->nullable()->default(null);
            $table->date('medical_card_expiration')->nullable()->default(null);
            $table->string('meddical_card_state')->nullable()->default(null);
            $table->string('caregiver_id_number')->nullable()->default(null);
            $table->enum('medical_status',['Pending','Approved','Rejected'])->default('Pending')->nullable()->comment("Pending,Approved,Rejected");
            // ========== ends ============

            $table->rememberToken();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
