<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCompaniesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('companies', function (Blueprint $table) {

            $table->id();
            $table->unsignedBigInteger('owner_id')->nullable();
            $table->unsignedBigInteger('type_id')->nullable();
            $table->foreign('owner_id')->references('id')->on('users')->onUpdate('cascade')->onDelete('cascade');
            // $table->foreign('type_id')->references('id')->on('company_types')->onUpdate('cascade')->onDelete('cascade');
            // $table->unsignedBigInteger('menu_type_id')->nullable();

            $table->string('name', 100);
            $table->string('address_line_1', 200)->nullable();
            $table->string('address_line_2', 200)->nullable();
            $table->integer('location_id')->nullable();
            // $table->unsignedBigInteger('location_id');
            $table->string('postal_code', 20)->nullable();
            $table->json('tips')->nullable();
            $table->json('hours')->nullable();
            $table->double('tax_rate', 8, 2)->nullable();
            $table->double('reservation_fee', 8, 2)->nullable();
            $table->bigInteger('reservation_before')->nullable();
            $table->double('cancelation_fee', 8, 2)->nullable();
            $table->bigInteger('utc_offset')->nullable();
            $table->decimal('lat', 8, 6)->nullable();
            $table->decimal('lng', 9, 6)->nullable();
            $table->json('meta')->nullable();
            $table->integer('rating')->nullable();
            $table->double('deal', 8, 2)->nullable();

            // $table->index('rating')->nullable();
            // $table->index('deal')->nullable();

            $table->string('country', 4)->nullable();
            $table->string('state', 64)->nullable();
            $table->string('city', 128)->nullable();
            $table->string('terminal_location_id', 128)->nullable();

            $table->string('logo')->nullable();
            $table->string('cover_photo')->nullable();
            $table->string('banner_photo')->nullable();
            $table->tinyInteger('status')->default(0);
            $table->tinyInteger('temporary_close')->default(0);
            $table->tinyInteger('coming_soon')->default(0);
            $table->tinyInteger('business_active')->default(0);
            $table->integer('payouts_days')->default(1);
            $table->double('minimum_order_limit')->nullable();
            $table->integer('order_processing_time')->default('10');
            
            $table->string('business_latitude')->nullable();
            $table->string('business_longitude')->nullable();
            $table->string('business_timezone')->nullable();
            
            //$table->foreign('menu_type_id')->references('id')->on('company_menu_types')->onUpdate('cascade')->onDelete('cascade');
            // $table->foreign('location_id')->references('id')->on('locations');

            $table->string("slug");
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('companies');
    }
}
