<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('discounts', function (Blueprint $table) {
 
            $table->id();
            $table->unsignedBigInteger('company_id');
            $table->enum('status', ['new', 'active', 'completed'])->default('new');
            $table->string('name', 100)->nullable();
            $table->timestamp('starts_at')->nullable();
            $table->timestamp('ends_at')->nullable();
            $table->integer('terms')->nullable();
            $table->integer('max_users')->nullable();
            $table->double('max_amount', 8, 2)->nullable();
            $table->double('amount', 8, 2)->nullable();
            $table->index('status');
            $table->integer('total_no_of_discounts')->default(0);
            $table->double('max_discount_per_order', 8, 2)->nullable();
            $table->string("pt_type", 20)->nullable();
            $table->timestamp("pt_starts_at")->nullable();
            $table->integer("pt_total_hours")->nullable();
            $table->integer("pt_percentage")->nullable();
            $table->double("pt_paying_amount", 8, 2)->nullable();
            $table->timestamps();
            $table->softDeletes();

            // $table->foreign('company_id')
            //     ->references('id')
            //     ->on('companies')
            //     ->onUpdate('cascade')
            //     ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        Schema::dropIfExists('discounts');
        DB::statement('SET FOREIGN_KEY_CHECKS = 1');
    }
};
