<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('promos', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id')->nullable();
            $table->string('address')->nullable();
            $table->text('description')->nullable();
            $table->string('title')->nullable();
            $table->integer('value')->nullable();
            // $table->decimal('price', 10, 0)->nullable();
            $table->json('price')->change();
            $table->timestamp('ended_at')->nullable();
            $table->timestamp('opens_at')->nullable();
            $table->json('services')->nullable();
            $table->string('status')->default(0)->comment("0 = comming soon, 1= now open");
            $table->timestamps();
            $table->foreign('company_id')
                ->references('id')
                ->on('companies')
                ->onUpdate('cascade')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('promos');
    }
};
