<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_promo', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('promo_id')->nullable();
            $table->unsignedBigInteger('promo_type_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->string("type")->nullable();
            $table->integer('amount')->nullable();
            $table->integer('taxes')->nullable();
            $table->integer('total')->nullable();
            $table->string('status')->nullable();
            $table->string("action", 50)->nullable();
            $table->string("restaurant_type", 120)->nullable();

            $table->unsignedBigInteger('transaction_id')->nullable();
            

            $table->foreign('promo_id')
            ->references('id')
            ->on('promos')
            ->onUpdate('cascade')
            ->onDelete('cascade');

            $table->foreign('promo_type_id')
            ->references('id')
            ->on('promo_types')
            ->onUpdate('cascade')
            ->onDelete('cascade');

            $table->foreign('user_id')
            ->references('id')
            ->on('users')
            ->onUpdate('cascade')
            ->onDelete('cascade');

            $table->foreign('transaction_id')
            ->references('id')
            ->on('transactions')
            ->onUpdate('cascade')
            ->onDelete('cascade');

            $table->string('order_code' , 220)->nullable();
            $table->integer('total_claim')->default('0');
            $table->integer('company_id')->nullable();
            $table->integer('parent_promo_id')->nullable()->comment("will be use for receipent");
            $table->tinyInteger('regular_free')->default(0);
            $table->enum('added_to_total',['yes','no'])->default('no')->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_promo');
    }
};
