<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('rewards', function (Blueprint $table) {
            $table->id();
            $table->integer('company_id');
            $table->integer('status')->nullable()->comment('paused', 'active');
            $table->string('name')->nullable();
            $table->integer('cycle_amount')->nullable();
            $table->integer('type')->nullable()->comment('percent', 'product');
            $table->integer('discount_percent')->nullable();
            $table->integer('discount_max')->nullable();
            $table->integer('product_id')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('rewards');
    }
};
