<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_stripe_infos', function (Blueprint $table) {
            $table->id();
            $table->integer('customer_id')->nullable()->comment('This customer_id belongs to our users id');
            $table->string('stripe_cus_id')->nullable()->comment('Stripe customer id');
            $table->string('stripe_pm_id')->nullable()->comment('Stripe payment method id');
            $table->string('stripe_ch_id')->nullable()->comment('Stripe charge id');
            $table->string('card_last_4_digits', 4);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_stripe_infos');
    }
};
