<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('carts', function (Blueprint $table) {
            $table->id();
            $table->integer('company_id');
            $table->integer('user_id')->nullable();
            $table->string('temp_user_id')->nullable();
            $table->integer('product_id');
            $table->string('name');
            $table->integer('price');
            $table->integer('quantity');
            $table->json('toppings')->nullable();
            $table->integer('table_id')->default('0');
            $table->json("option_data")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('carts');
    }
};
