<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_products', function (Blueprint $table) {
            $table->id();
            $table->integer('product_id');
            $table->integer('order_id')->nullable();
            $table->integer('user_order_id')->nullable();
            $table->string("product_name")->nullable();
            $table->integer('product_qty');
            $table->double('product_unit_price');
            $table->enum('product_type',['size','group'])->nullable();
            $table->double('product_total_price');
            $table->double('product_total_size_price')->nullable();
            $table->double('product_total_options_price')->nullable();
            $table->double('product_subtotal');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_products');
    }
};
