<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_reservations', function (Blueprint $table) {
            $table->id();
            $table->integer('status')->default(0);
            $table->integer('customer_id');
            $table->integer('company_id');
            $table->integer('order_id')->nullable();
            $table->integer('table_id')->nullable();
            $table->integer('party_size')->nullable();
            $table->dateTime('datetime')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reservations');
    }
};
