<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_product', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->onDelete("cascade");
            $table->foreignId('employee_id')->nullable();
            $table->foreignId('user_id')->constrained()->onDelete("cascade");
            $table->foreignId('product_id')->constrained()->onDelete("cascade");
            $table->longText("product_options")->nullable();
            $table->integer('amount')->nullable();
            $table->decimal('price', 10, 0)->nullable();
            $table->timestamps();
            $table->softDeletes();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_product');
    }
};
