<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }}</title>


    {{-- <link rel="stylesheet" href="{{ asset('restaurant/style.css?v=1') }}"> --}}
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('restaurant/favicon.ico') }}">

    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet" />


    <link rel="stylesheet" href="{{ asset('assets/css/bootstrap.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/custom.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />


    @stack("styles")

    <!-- Scripts -->
    
    <style>
        body{
            background: #F9F9FB;
        }

        #cc_number, #cc_expiry, #cc_cvv {
            padding: 0.7rem 0.75rem;
            border: 1px solid #CBD5E1;
            border-radius: 6px;
        }
    </style>
</head>

<body>
    <div class="container my-5">
        <div class="row my-5">
            <div class="col-md-6 mx-auto">
                <div class="card border-0 p-3">
                    <div class="card-header bg-white border-0">
                        <h6 class="fw-bold">Add Card</h6>
                    </div>
                    <div class="card-body">
                        <form>

                            <div class="mb-3">
                                <label for="cc_number" class="form-label text-nowrap">Card Number</label>
                                {{-- <input type="text" pattern="[0-9 ]+" maxlength="19" class="form-control" placeholder="Card Number" id="cc_number" name="cc_number"> --}}
                                <div id="cc_number"></div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="cc_expiry" class="form-label text-nowrap">Expiry Date</label>
                                        {{-- <input type="text" class="form-control" placeholder="MM/YY" id="cc_expiry" name="cc_expiry" maxlength="5"> --}}
                                        <div id="cc_expiry"></div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="cc_cvv" class="form-label text-nowrap">CVV</label>
                                        <div id="cc_cvv"></div>
                                        {{-- <input type="text" class="form-control" placeholder="CVV" id="cc_cvc" name="cc_cvc" maxlength="4" > --}}
                                    </div>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="zip_code" class="form-label text-nowrap">ZIP Code</label>
                                <input type="text" pattern="[0-9 ]+" maxlength="8"  class="form-control" placeholder="" id="zip_code" name="zip_code">
                            </div>
                            
                            <div class="text-danger mb-3" id="error"></div>
                            <div class="mb-3">
                                <button type="button" class="btn btn-primary w-100" id="addcardbtn">
                                    <svg id="loader" style="display: none;" fill="#ffffff" width="24" height="24" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M12,1A11,11,0,1,0,23,12,11,11,0,0,0,12,1Zm0,19a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z" opacity=".65"/><circle cx="12" cy="2.5" r="1.5"><animateTransform attributeName="transform" type="rotate" dur="0.75s" values="0 12 12;360 12 12" repeatCount="indefinite"/></circle></svg>
                                    Continue
                                </button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://js.stripe.com/v3/"></script>

    <script>
        var stripe = Stripe('pk_test_51Oht7GJtynmhChwGyLTeaMxJedPvXjiXT8Eayi8a4ouTs83dxWFo8QmW3nfSu4uPtNn6tGsjasGO7xKZZW1TtPVv00dCPeYqgz');
        var elements = stripe.elements({  });
        $(document).ready(function(){

            
            const appearance = {};
            const clientSecret = '';
            // elements = stripe.elements({  });    
            // var cardElement = elements.create('card', {disableLink: true});
            // cardElement.mount('#card-element');

            var cardNumber = elements.create('cardNumber', {});
            cardNumber.mount('#cc_number');

            var cardExpiry = elements.create('cardExpiry', {});
            cardExpiry.mount('#cc_expiry');

            var cardCvc = elements.create('cardCvc', {});
            cardCvc.mount('#cc_cvv');
            
        });
    </script>

    <script>
        $(document).ready(function(){

            $("#addcardbtn").on("click", function(){
                
                const zip_code = $("#zip_code").val();
                $("#error").html("");
                $("#loader").show();
                const element = this;
                $(element).prop("disabled", true);

                stripe
                .createPaymentMethod({
                    type: 'card',
                    card: elements.getElement('cardNumber'),
                    billing_details: {
                        name: "{{ Auth::user()->name }}",
                        email: "{{ Auth::user()->email }}",
                        phone: "{{ Auth::user()->phone_number }}",
                        address: {
                            postal_code: zip_code
                        }
                    },
                })
                .then(function(result) {
                    console.log(result);
                    if(result.error){
                        $("#error").html(result.error.message);
                        $(element).prop("disabled", false);
                    }else{
                        const last_four = result.paymentMethod.card.last4;
                        const pm_id = result.paymentMethod.id;

                        $.ajax({
                            url: "{{ route('webapi.customer.savecard') }}",
                            type: "POST",
                            data: {
                                _token: "{{ csrf_token() }}",
                                pm_id: pm_id,
                                last_four: last_four
                            },
                            success: function(response) {
                                window.location.href = localStorage.getItem("HTTP_REFERRER") ?? "/";
                                $(element).prop("disabled", false);
                            },
                            error: function(jqXHR, textStatus, errorThrown) {
                                console.log(textStatus, errorThrown);
                                $(element).prop("disabled", false);
                            }
                        });

                    }
                    $("#loader").hide();
                });

            });
           

        });
    </script>
</body>

</html>