<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Company Image') }}
        </h2>
    </x-slot>

    <div class="py-2">
        <div class="max-w-7xl mx-auto">
            <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg p-6">

                {{-- Logo --}}
                <div class="grid grid-cols-2 gap-2">
                    <div class="mb-3">
                        <h5 class="text-lg fw-500">Logo</h5>
                        
                        <img class="mx-auto my-5" src="{{ $logo_url }}" id="logo" alt="logo" style="height: 200px; width: 200px;">
                    </div>
                    <div class="mb-3">
                        <form action="{{ route('company.logo.upload') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            
                            <div class="mb-3">
                                <label class="block font-medium text-sm text-gray-700" for="logo">
                                    Logo
                                </label>
                                <input name="logo" class="p-2 block w-full text-sm text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 dark:text-gray-400 focus:outline-none" id="image" type="file">
                            </div>

                            <div class="mb-3">
                                <button type="submit"
                                    class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 focus:bg-gray-700 active:bg-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150">
                                    Upload
                                </button>
                            </div>

                        </form>
                    </div>
                </div>
                <hr class="mb-5">

                {{-- Cover --}}
                <div class="grid grid-cols-2 gap-2">
                    <div class="mb-3">
                        <h5 class="text-lg fw-500">Cover Image</h5>
                        <img class="mx-auto my-5" src="{{ $cover_url }}" id="cover_image" alt="cover_image" style="height: 200px; width: 200px;">
                    </div>
                    <div class="mb-3">
                        <form action="{{ route('company.cover.upload') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            
                            <div class="mb-3">
                                <label class="block font-medium text-sm text-gray-700" for="cover_image">
                                    Cover Image
                                </label>
                                <input name="cover_image" class="p-2 block w-full text-sm text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 dark:text-gray-400 focus:outline-none" id="image" type="file">
                            </div>

                            <div class="mb-3">
                                <button type="submit"
                                    class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 focus:bg-gray-700 active:bg-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150">
                                    Upload
                                </button>
                            </div>

                        </form>
                    </div>
                </div>
                <hr class="mb-5">

                {{-- Banner --}}
                <div class="grid grid-cols-2 gap-2">
                    <div class="mb-3">
                        <h5 class="text-lg fw-500">Banner Image</h5>
                        <img class="mx-auto my-5" src="{{ $banner_url }}" id="banner" alt="banner_image" style="height: 200px; width: 200px;">
                    </div>
                    <div class="mb-3">
                        <form action="{{ route('company.banner.upload') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            
                            <div class="mb-3">
                                <label class="block font-medium text-sm text-gray-700" for="banner_image">
                                    Banner Image
                                </label>
                                <input name="banner_image" class="p-2 block w-full text-sm text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 dark:text-gray-400 focus:outline-none" id="image" type="file">
                            </div>

                            <div class="mb-3">
                                <button type="submit"
                                    class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 focus:bg-gray-700 active:bg-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150">
                                    Upload
                                </button>
                            </div>

                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>
</x-app-layout>
