<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Discount') }}
        </h2>
    </x-slot>

    <div class="py-2">
        <div class="max-w-7xl mx-auto">

                <nav class="flex mb-3" aria-label="Breadcrumb">
                    <ol class="inline-flex items-center space-x-1 md:space-x-3">
                        <li class="inline-flex items-center">
                            <a href="/business-app/dashboard"
                                class="inline-flex items-center text-sm font-medium text-gray-700 hover:text-blue-600">
                                <svg class="w-3 h-3 mr-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                    fill="currentColor" viewBox="0 0 20 20">
                                    <path
                                        d="m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2a1 1 0 0 0 1.414 1.414L2 10.414V18a2 2 0 0 0 2 2h3a1 1 0 0 0 1-1v-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v4a1 1 0 0 0 1 1h3a2 2 0 0 0 2-2v-7.586l.293.293a1 1 0 0 0 1.414-1.414Z">
                                    </path>
                                </svg>
                                Home
                            </a>
                        </li>

                        <li aria-current="page">
                            <div class="flex items-center">
                                <svg class="w-3 h-3 text-gray-400 mx-1" aria-hidden="true"
                                    xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 6 10">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                        stroke-width="2" d="m1 9 4-4-4-4"></path>
                                </svg>
                                <span class="ml-1 text-sm font-medium text-gray-500 md:ml-2">Create Discount</span>
                            </div>
                        </li>
                    </ol>
                </nav>


            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
                <form @submit.prevent="submitCreateForm" method="POST">
                    <input type="hidden" name="_token" value="BMOj6OpMBBAhaeW9wqGb4PVsVB7ffV9eIxLSbMM3">

                     <!-- Name -->
                     <div class="mb-3">
                        <label class="block font-medium text-sm text-gray-700" for="name">
                            Name
                        </label>
                        <input
                            class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                            id="name" type="text" name="name" autofocus="autofocus"
                            autocomplete="name" v-model="form.name">
                        <small v-if="errors.name" class="text-red-500">@{{ errors.name[0] }}</small>
                    </div>

                    <!-- Starts At -->
                    <div class="mb-3">
                        <label class="block font-medium text-sm text-gray-700" for="starts_at">
                            Starts At
                        </label>
                        <input
                            class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                            id="starts_at" type="datetime-local" name="starts_at" autofocus="autofocus"
                            autocomplete="starts_at" v-model="form.starts_at">
                        <small v-if="errors.starts_at" class="text-red-500">@{{ errors.starts_at[0] }}</small>
                    </div>

                    <!-- Pause Discount -->
                    <div class="mb-3">
                        <label class="block font-medium text-sm text-gray-700" for="starts_at">
                            Pause Discount
                        </label>
                        <select v-model="form.pause_discount" id="pause_discount" name="pause_discount" autofocus=""
                            class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500  rounded-md shadow-sm">
                            <option value="yes">Yes</option>
                            <option value="no">No</option>
                        </select>
                        <small v-if="errors.pause_discount" class="text-red-500">@{{ errors.pause_discount[0] }}</small>
                    </div>

                    <!-- Select Percent OFF -->
                    <div class="mb-3">
                        <label class="block font-medium text-sm text-gray-700" for="percentage_off">
                            Percent Off (Ex. 40)
                        </label>
                        <select @change="calculateCreditAmount" v-model="form.percentage_off" id="percentage_off" name="percentage_off" autofocus=""
                            class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500  rounded-md shadow-sm">
                            <option value="">Seletct Percent off</option>
                            <option value="10">10% off</option>
                            <option value="15">15% off</option>
                            <option value="20">20% off</option>
                            <option value="25">25% off</option>
                            <option value="30">30% off</option>
                            <option value="40">40% off</option>
                            <option value="50">50% off</option>
                            <option value="75">75% off</option>
                            <option value="90">90% off</option>
                        </select>
                        <div>
                            <small>
                                Percent Off should be from 1% to 50%.
                            </small>
                        </div>
                        <small v-if="errors.percentage_off" class="text-red-500">@{{ errors.percentage_off[0] }}</small>
                    </div>

                    <div class="border rounded-md p-5 mb-3">
                        <!--  Launce Prime Time -->
                     <div class="mb-3">
                        <label class="block font-medium text-sm text-gray-700" for="description">
                            Launce Prime Time
                        </label>
                        <div class="flex items-center">
                            <button @click="form.prime_time = 'now'" type="button" :class="`py-2.5 px-5 me-2 mb-2 text-sm font-medium focus:outline-none ${form.prime_time == 'now' ? 'bg-blue-500 text-white' : 'bg-white text-gray-900'} rounded-lg border border-gray-200`">Now</button>
                            <span class="mx-1"></span>
                            <button @click="form.prime_time = 'schedule'" type="button" :class="`py-2.5 px-5 me-2 mb-2 text-sm font-medium focus:outline-none ${form.prime_time == 'schedule' ? 'bg-blue-500 text-white' : 'bg-white text-gray-900'} rounded-lg border border-gray-200`">Schedule</button>
                            <span class="mx-1"></span>
                            <button @click="form.prime_time = 'prize_hour'" type="button" :class="`py-2.5 px-5 me-2 mb-2 text-sm font-medium focus:outline-none ${form.prime_time == 'prize_hour' ? 'bg-blue-500 text-white' : 'bg-white text-gray-900'} rounded-lg border border-gray-200`">Prize Hour</button>
                        </div>
                    </div>

                    <template v-if="form.prime_time == 'prize_hour'">
                        <div v-for="(phour, idx) in form.prize_hours" class="grid grid-cols-12 gap-4">
                            <div class="col-span-4">
                                <div class="mb-3">
                                    <label class="block font-medium text-sm text-gray-700" for="prime_starts_at">
                                        Day
                                    </label>
                                    <select name="prize_hour" id="prize_hour" v-model="phour.day" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500  rounded-md shadow-sm">
                                        <option>Select Day</option>
                                        <option value="1">Monday</option>
                                        <option value="2">Tuesday</option>
                                        <option value="3">Wednesday</option>
                                        <option value="4">Thursday</option>
                                        <option value="5">Friday</option>
                                        <option value="6">Saturday</option>
                                        <option value="7">Sunday</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-span-4">
                                <div class="mb-3">
                                    <label class="block font-medium text-sm text-gray-700" for="prime_starts_at">
                                        Starts At
                                    </label>
                                    <select name="prize_hour" id="prize_hour" v-model="phour.starts_at" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500  rounded-md shadow-sm">
                                        <option>Select from</option>
                                        <option value="00:00:00">12:00 am</option>
                                        <option value="00:15:00">12:15 am</option>
                                        <option value="00:30:00">12:30 am</option>
                                        <option value="00:45:00">12:45 am</option>
                                        <option value="01:00:00">01:00 am</option>
                                        <option value="01:15:00">01:15 am</option>
                                        <option value="01:30:00">01:30 am</option>
                                        <option value="01:45:00">01:45 am</option>
                                        <option value="02:00:00">02:00 am</option>
                                        <option value="02:15:00">02:15 am</option>
                                        <option value="02:30:00">02:30 am</option>
                                        <option value="02:45:00">02:45 am</option>
                                        <option value="03:00:00">03:00 am</option>
                                        <option value="03:15:00">03:15 am</option>
                                        <option value="03:30:00">03:30 am</option>
                                        <option value="03:45:00">03:45 am</option>
                                        <option value="04:00:00">04:00 am</option>
                                        <option value="04:15:00">04:15 am</option>
                                        <option value="04:30:00">04:30 am</option>
                                        <option value="04:45:00">04:45 am</option>
                                        <option value="05:00:00">05:00 am</option>
                                        <option value="05:15:00">05:15 am</option>
                                        <option value="05:30:00">05:30 am</option>
                                        <option value="05:45:00">05:45 am</option>
                                        <option value="06:00:00">06:00 am</option>
                                        <option value="06:15:00">06:15 am</option>
                                        <option value="06:30:00">06:30 am</option>
                                        <option value="06:45:00">06:45 am</option>
                                        <option value="07:00:00">07:00 am</option>
                                        <option value="07:15:00">07:15 am</option>
                                        <option value="07:30:00">07:30 am</option>
                                        <option value="07:45:00">07:45 am</option>
                                        <option value="08:00:00">08:00 am</option>
                                        <option value="08:15:00">08:15 am</option>
                                        <option value="08:30:00">08:30 am</option>
                                        <option value="08:45:00">08:45 am</option>
                                        <option value="09:00:00">09:00 am</option>
                                        <option value="09:15:00">09:15 am</option>
                                        <option value="09:30:00">09:30 am</option>
                                        <option value="09:45:00">09:45 am</option>
                                        <option value="10:00:00">10:00 am</option>
                                        <option value="10:15:00">10:15 am</option>
                                        <option value="10:30:00">10:30 am</option>
                                        <option value="10:45:00">10:45 am</option>
                                        <option value="11:00:00">11:00 am</option>
                                        <option value="11:15:00">11:15 am</option>
                                        <option value="11:30:00">11:30 am</option>
                                        <option value="11:45:00">11:45 am</option>
                                        <option value="12:00:00">12:00 pm</option>
                                        <option value="12:15:00">12:15 pm</option>
                                        <option value="12:30:00">12:30 pm</option>
                                        <option value="12:45:00">12:45 pm</option>
                                        <option value="13:00:00">01:00 pm</option>
                                        <option value="13:15:00">01:15 pm</option>
                                        <option value="13:30:00">01:30 pm</option>
                                        <option value="13:45:00">01:45 pm</option>
                                        <option value="14:00:00">02:00 pm</option>
                                        <option value="14:15:00">02:15 pm</option>
                                        <option value="14:30:00">02:30 pm</option>
                                        <option value="14:45:00">02:45 pm</option>
                                        <option value="15:00:00">03:00 pm</option>
                                        <option value="15:15:00">03:15 pm</option>
                                        <option value="15:30:00">03:30 pm</option>
                                        <option value="15:45:00">03:45 pm</option>
                                        <option value="16:00:00">04:00 pm</option>
                                        <option value="16:15:00">04:15 pm</option>
                                        <option value="16:30:00">04:30 pm</option>
                                        <option value="16:45:00">04:45 pm</option>
                                        <option value="17:00:00">05:00 pm</option>
                                        <option value="17:15:00">05:15 pm</option>
                                        <option value="17:30:00">05:30 pm</option>
                                        <option value="17:45:00">05:45 pm</option>
                                        <option value="18:00:00">06:00 pm</option>
                                        <option value="18:15:00">06:15 pm</option>
                                        <option value="18:30:00">06:30 pm</option>
                                        <option value="18:45:00">06:45 pm</option>
                                        <option value="19:00:00">07:00 pm</option>
                                        <option value="19:15:00">07:15 pm</option>
                                        <option value="19:30:00">07:30 pm</option>
                                        <option value="19:45:00">07:45 pm</option>
                                        <option value="20:00:00">08:00 pm</option>
                                        <option value="20:15:00">08:15 pm</option>
                                        <option value="20:30:00">08:30 pm</option>
                                        <option value="20:45:00">08:45 pm</option>
                                        <option value="21:00:00">09:00 pm</option>
                                        <option value="21:15:00">09:15 pm</option>
                                        <option value="21:30:00">09:30 pm</option>
                                        <option value="21:45:00">09:45 pm</option>
                                        <option value="22:00:00">10:00 pm</option>
                                        <option value="22:15:00">10:15 pm</option>
                                        <option value="22:30:00">10:30 pm</option>
                                        <option value="22:45:00">10:45 pm</option>
                                        <option value="23:00:00">11:00 pm</option>
                                        <option value="23:15:00">11:15 pm</option>
                                        <option value="23:30:00">11:30 pm</option>
                                        <option value="23:45:00">11:45 pm</option>
                                        <option value="23:59:00">11:59 pm</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-span-4 flex items-center mb-3">
                                <div class="w-full">
                                    <label class="block font-medium text-sm text-gray-700" for="prime_starts_at">
                                        Ends At
                                    </label>
                                    <select name="prize_hour" id="prize_hour" v-model="phour.ends_at" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500  rounded-md shadow-sm">
                                        <option>Select to</option>
                                        <option value="00:00:00">12:00 am</option>
                                        <option value="00:15:00">12:15 am</option>
                                        <option value="00:30:00">12:30 am</option>
                                        <option value="00:45:00">12:45 am</option>
                                        <option value="01:00:00">01:00 am</option>
                                        <option value="01:15:00">01:15 am</option>
                                        <option value="01:30:00">01:30 am</option>
                                        <option value="01:45:00">01:45 am</option>
                                        <option value="02:00:00">02:00 am</option>
                                        <option value="02:15:00">02:15 am</option>
                                        <option value="02:30:00">02:30 am</option>
                                        <option value="02:45:00">02:45 am</option>
                                        <option value="03:00:00">03:00 am</option>
                                        <option value="03:15:00">03:15 am</option>
                                        <option value="03:30:00">03:30 am</option>
                                        <option value="03:45:00">03:45 am</option>
                                        <option value="04:00:00">04:00 am</option>
                                        <option value="04:15:00">04:15 am</option>
                                        <option value="04:30:00">04:30 am</option>
                                        <option value="04:45:00">04:45 am</option>
                                        <option value="05:00:00">05:00 am</option>
                                        <option value="05:15:00">05:15 am</option>
                                        <option value="05:30:00">05:30 am</option>
                                        <option value="05:45:00">05:45 am</option>
                                        <option value="06:00:00">06:00 am</option>
                                        <option value="06:15:00">06:15 am</option>
                                        <option value="06:30:00">06:30 am</option>
                                        <option value="06:45:00">06:45 am</option>
                                        <option value="07:00:00">07:00 am</option>
                                        <option value="07:15:00">07:15 am</option>
                                        <option value="07:30:00">07:30 am</option>
                                        <option value="07:45:00">07:45 am</option>
                                        <option value="08:00:00">08:00 am</option>
                                        <option value="08:15:00">08:15 am</option>
                                        <option value="08:30:00">08:30 am</option>
                                        <option value="08:45:00">08:45 am</option>
                                        <option value="09:00:00">09:00 am</option>
                                        <option value="09:15:00">09:15 am</option>
                                        <option value="09:30:00">09:30 am</option>
                                        <option value="09:45:00">09:45 am</option>
                                        <option value="10:00:00">10:00 am</option>
                                        <option value="10:15:00">10:15 am</option>
                                        <option value="10:30:00">10:30 am</option>
                                        <option value="10:45:00">10:45 am</option>
                                        <option value="11:00:00">11:00 am</option>
                                        <option value="11:15:00">11:15 am</option>
                                        <option value="11:30:00">11:30 am</option>
                                        <option value="11:45:00">11:45 am</option>
                                        <option value="12:00:00">12:00 pm</option>
                                        <option value="12:15:00">12:15 pm</option>
                                        <option value="12:30:00">12:30 pm</option>
                                        <option value="12:45:00">12:45 pm</option>
                                        <option value="13:00:00">01:00 pm</option>
                                        <option value="13:15:00">01:15 pm</option>
                                        <option value="13:30:00">01:30 pm</option>
                                        <option value="13:45:00">01:45 pm</option>
                                        <option value="14:00:00">02:00 pm</option>
                                        <option value="14:15:00">02:15 pm</option>
                                        <option value="14:30:00">02:30 pm</option>
                                        <option value="14:45:00">02:45 pm</option>
                                        <option value="15:00:00">03:00 pm</option>
                                        <option value="15:15:00">03:15 pm</option>
                                        <option value="15:30:00">03:30 pm</option>
                                        <option value="15:45:00">03:45 pm</option>
                                        <option value="16:00:00">04:00 pm</option>
                                        <option value="16:15:00">04:15 pm</option>
                                        <option value="16:30:00">04:30 pm</option>
                                        <option value="16:45:00">04:45 pm</option>
                                        <option value="17:00:00">05:00 pm</option>
                                        <option value="17:15:00">05:15 pm</option>
                                        <option value="17:30:00">05:30 pm</option>
                                        <option value="17:45:00">05:45 pm</option>
                                        <option value="18:00:00">06:00 pm</option>
                                        <option value="18:15:00">06:15 pm</option>
                                        <option value="18:30:00">06:30 pm</option>
                                        <option value="18:45:00">06:45 pm</option>
                                        <option value="19:00:00">07:00 pm</option>
                                        <option value="19:15:00">07:15 pm</option>
                                        <option value="19:30:00">07:30 pm</option>
                                        <option value="19:45:00">07:45 pm</option>
                                        <option value="20:00:00">08:00 pm</option>
                                        <option value="20:15:00">08:15 pm</option>
                                        <option value="20:30:00">08:30 pm</option>
                                        <option value="20:45:00">08:45 pm</option>
                                        <option value="21:00:00">09:00 pm</option>
                                        <option value="21:15:00">09:15 pm</option>
                                        <option value="21:30:00">09:30 pm</option>
                                        <option value="21:45:00">09:45 pm</option>
                                        <option value="22:00:00">10:00 pm</option>
                                        <option value="22:15:00">10:15 pm</option>
                                        <option value="22:30:00">10:30 pm</option>
                                        <option value="22:45:00">10:45 pm</option>
                                        <option value="23:00:00">11:00 pm</option>
                                        <option value="23:15:00">11:15 pm</option>
                                        <option value="23:30:00">11:30 pm</option>
                                        <option value="23:45:00">11:45 pm</option>
                                        <option value="23:59:00">11:59 pm</option>
                                    </select>
                                </div>
                                <div class="ms-1">
                                    <label class="invisible block font-medium text-sm text-gray-700" for="prime_starts_at">
                                        sss
                                    </label>
                                    <button @click="() => deleteThisDay(idx)" type="button" class="inline-flex items-center p-2 bg-red-600 hover:red-red-700 text-white text-sm font-medium rounded-md">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                        </svg>
                                    </button> 
                                </div>
                            </div>
                        </div>
                        <div @click="addAnotherDay" class="flex items-center mb-3" role="button">
                            <svg class="w-4 h-4" fill="#3b83f6" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="64px" height="64px" viewBox="0 0 45.402 45.402" xml:space="preserve" stroke="#3b83f6"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g> <path d="M41.267,18.557H26.832V4.134C26.832,1.851,24.99,0,22.707,0c-2.283,0-4.124,1.851-4.124,4.135v14.432H4.141 c-2.283,0-4.139,1.851-4.138,4.135c-0.001,1.141,0.46,2.187,1.207,2.934c0.748,0.749,1.78,1.222,2.92,1.222h14.453V41.27 c0,1.142,0.453,2.176,1.201,2.922c0.748,0.748,1.777,1.211,2.919,1.211c2.282,0,4.129-1.851,4.129-4.133V26.857h14.435 c2.283,0,4.134-1.867,4.133-4.15C45.399,20.425,43.548,18.557,41.267,18.557z"></path> </g> </g></svg>
                            <span class="text-blue-500 font-semibold ms-1">Add Another Day</span>
                        </div>
                    </template>
 
                    <!-- Starts At -->
                    <div class="mb-3" v-if="form.prime_time == 'schedule'">
                        <label class="block font-medium text-sm text-gray-700" for="prime_starts_at">
                            Starts At
                        </label>
                        <input
                            class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                            id="prime_starts_at" type="datetime-local" step="any" name="prime_starts_at" v-model="form.prime_starts_at">
                        <small v-if="errors.prime_starts_at" class="text-red-500">@{{ errors.prime_starts_at[0] }}</small>
                    </div>

                    <template v-if="form.prime_time">
                         <!-- Prime Time Total Hours -->
                        <div class="mb-3">
                            <label class="block font-medium text-sm text-gray-700" for="description">
                                Prime Time Total Hours
                            </label>
                            <input
                                class="border-gra y-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                                id="prime_total_hours" type="number" name="prime_total_hours" autofocus="autofocus"
                                autocomplete="prime_total_hours" v-model="form.prime_total_hours">
                            <small v-if="errors.prime_total_hours" class="text-red-500">@{{ errors.prime_total_hours[0] }}</small>
                        </div>

                        <!-- Select Percent OFF -->
                        <div class="mb-3">
                            <label class="block font-medium text-sm text-gray-700" for="prime_percentage_off">
                                Percent Off (Ex. 40)
                            </label>
                            <select v-model="form.prime_percentage_off" id="prime_percentage_off" name="prime_percentage_off" autofocus=""
                                class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500  rounded-md shadow-sm">
                                <option value="">Seletct Percent off</option>
                                <option value="10">10% off</option>
                                <option value="15">15% off</option>
                                <option value="20">20% off</option>
                                <option value="25">25% off</option>
                                <option value="30">30% off</option>
                                <option value="40">40% off</option>
                                <option value="50">50% off</option>
                                <option value="75">75% off</option>
                                <option value="90">90% off</option>
                            </select>
                            <div>
                                <small>
                                    Percent Off should be from 1% to 50%.
                                </small>
                            </div>
                            <small v-if="errors.prime_percentage_off" class="text-red-500">@{{ errors.prime_percentage_off[0] }}</small>
                        </div>
                    </template>
                    </div>

                    <!-- Limit Claims -->
                    <div class="mb-3">
                        <label class="block font-medium text-sm text-gray-700" for="description">
                            Limit Claims
                        </label>
                        <input
                            class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                            id="limit_claims" type="number" name="limit_claims" autofocus="autofocus"
                            autocomplete="limit_claims" v-model="form.limit_claims">
                        <div><small>Number of users can claim this discount. When the number of claims exceeds this number no one else can claim it. Leave 0 for unlimited claims.</small></div>
                        <small v-if="errors.limit_claims" class="text-red-500">@{{ errors.limit_claims[0] }}</small>
                    </div>

                    <!-- Credit Amount -->
                    <div class="mb-3">
                        <label class="block font-medium text-sm text-gray-700" for="description">
                            Credit Amount
                        </label>
                        <input
                            class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                            id="credit_amount" type="number" name="credit_amount" autofocus="autofocus"
                            autocomplete="credit_amount" v-model="form.credit_amount" @keyup="calculateCreditAmount">
                        <div> <small>List of Credit Amount per user/claim.</small> <small v-if="form.pay_amount > 0">Customer is paying $@{{ form.pay_amount }} to get this deal</small> </div>
                        <small v-if="errors.credit_amount" class="text-red-500">@{{ errors.credit_amount[0] }}</small>
                    </div>

                    <!-- Maximum Discount -->
                    <div class="mb-3" v-if="form.percentage_off && form.percentage_off > 30">
                        <label class="block font-medium text-sm text-gray-700" for="maximum_discount">
                            Maximum Discount
                        </label>
                        <input
                            class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                            id="maximum_discount" type="number" name="maximum_discount" autofocus="autofocus"
                            autocomplete="maximum_discount" v-model="form.maximum_discount" @keyup="calculateCreditAmount">
                        <div><small>Max Discount amount per order.</small></div>
                        <small v-if="errors.maximum_discount" class="text-red-500">@{{ errors.maximum_discount[0] }}</small>
                    </div>

                     <!-- Total Number of Discount -->
                     <div class="mb-3">
                        <label class="block font-medium text-sm text-gray-700" for="total_number_of_discount">
                            Total Number of Discount
                        </label>
                        <input
                            class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full"
                            id="total_number_of_discount" type="number" name="total_number_of_discount" autofocus="autofocus"
                            autocomplete="total_number_of_discount" v-model="form.total_number_of_discount">
                        <div>
                            <small>Total number of discounts.</small>
                        </div>
                        <small v-if="errors.total_number_of_discount" class="text-red-500">@{{ errors.total_number_of_discount[0] }}</small>
                    </div>

                    
                    <!-- <div class="mb-3">
                        <label class="inline-flex items-center cursor-pointer">
                            <input type="checkbox" value="1" class="sr-only peer" v-model="form.is_global">
                            <div class="relative w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600"></div>
                            <span class="ms-3 text-sm font-medium text-gray-900 dark:text-gray-300">Global</span>
                        </label>
                    </div> -->


                    <div class="mb-3">
                        <button type="submit"
                            class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 focus:bg-gray-700 active:bg-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150">
                            Submit
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@push("scripts")
<script src="https://unpkg.com/vue@3/dist/vue.global.js"></script>
<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>

<script>
  const { createApp, ref } = Vue

  createApp({
    data() {
        return {
            form: {
                user_timezone: '',
                name: '',
                starts_at: '',
                pause_discount: 'no',
                percentage_off: '',
                prime_time: '',
                prime_starts_at: '',
                prime_total_hours: '',
                prime_percentage_off: '',
                limit_claims: '',
                credit_amount: '',
                maximum_discount: '',
                total_number_of_discount: '',
                pay_amount: 0,
                is_global: false,
                prize_hours: [
                    {id: 0, day: '', starts_at: '', ends_at: ''}
                ]
                // csrf: document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            errors: {}
        }
    },
    created() {
        this.form.user_timezone = Intl.DateTimeFormat().resolvedOptions().timeZone;
    },
    methods: {
        submitCreateForm: async function () {
            // if(Object.keys(this.errors).length > 0){
            //     confirm("Please fix all errors");
            //     return false;
            // }
            try{
                const res = await axios.post("/create-company-discount", this.form, {
                    header: {
                        'Content-Type': 'application/json',
                        'Accept': 'application/json'
                    }
                });

                window.location.href = "{{ route('discount.index') }}";
            }catch(err){
                console.log(err.response.data);
                this.errors = err.response.data;
            }

           
            // this.discounts = res.data;
        },
        calculateCreditAmount: function(){
            // console.log(this.form.percentage_off, this.form.credit_amount);
            this.errors['credit_amount'] = null;
            this.errors['maximum_discount'] = null;
            const percentage_off = this.form.percentage_off;
            const credit_amount = this.form.credit_amount;
            if(!percentage_off || !credit_amount){
                return;
            }

            let off = 0;
            if(percentage_off >= 10 && percentage_off <= 25){
                if(credit_amount <= 120){
                    this.errors['credit_amount'] = ["Credit amount must be greater than 120"];
                }else{
                    off = credit_amount * (95/100);
                }
            }else if(percentage_off > 25 && percentage_off <= 30){
                if(credit_amount <= 100){
                    this.errors['credit_amount'] = ["Credit amount must be greater than 100"];
                }else{
                    off = credit_amount * (90/100);
                }
            }else if(percentage_off > 30 && percentage_off <= 50){
                if(credit_amount <= 50){
                    this.errors['credit_amount'] = ["Credit amount must be greater than 50"];
                }else{
                    off = credit_amount * (85/100);
                }
            }else if(percentage_off > 50 && percentage_off <= 90){
                if(credit_amount <= 30){
                    this.errors['credit_amount'] = ["Credit amount must be greater than 30"];
                }else{
                    off = credit_amount * (80/100);
                }
            }

            if(off > 0){
                let amount = parseFloat(credit_amount - off).toFixed(2);
                if(this.form.maximum_discount && amount > this.form.maximum_discount/2){
                    // this.form.pay_amount = this.form.maximum_discount;
                    this.errors['maximum_discount'] = ["Maximum discount must be 2x of paying amount"];
                }
                this.form.pay_amount = parseFloat(credit_amount - off).toFixed(2);
            }
        },
        addAnotherDay: function(){
            const id = this.form.prize_hours.length;
            if(id > 7) {
                alert("You can set max 7 days hours");
                return false;
            }
            this.form.prize_hours.push({
                id: id,
                day: '',
                starts_at: '',
                ends_at: '',
            });
        },
        deleteThisDay: function(index){
            const newDays = this.form.prize_hours.filter((data, i) => i != index);
            this.form.prize_hours = newDays;
        }
    },
  }).mount('#app')
</script>
@endpush
</x-app-layout>
