<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Menutype') }}
        </h2>
    </x-slot>

    <div class="py-2">
        <div class="max-w-7xl mx-auto">

                <nav class="flex mb-3" aria-label="Breadcrumb">
                    <ol class="inline-flex items-center space-x-1 md:space-x-3">
                        <li class="inline-flex items-center">
                            <a href="/business-app/dashboard"
                                class="inline-flex items-center text-sm font-medium text-gray-700 hover:text-blue-600">
                                <svg class="w-3 h-3 mr-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                    fill="currentColor" viewBox="0 0 20 20">
                                    <path
                                        d="m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2a1 1 0 0 0 1.414 1.414L2 10.414V18a2 2 0 0 0 2 2h3a1 1 0 0 0 1-1v-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v4a1 1 0 0 0 1 1h3a2 2 0 0 0 2-2v-7.586l.293.293a1 1 0 0 0 1.414-1.414Z">
                                    </path>
                                </svg>
                                Home
                            </a>
                        </li>

                        <li aria-current="page">
                            <div class="flex items-center">
                                <svg class="w-3 h-3 text-gray-400 mx-1" aria-hidden="true"
                                    xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 6 10">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                        stroke-width="2" d="m1 9 4-4-4-4"></path>
                                </svg>
                                <span class="ml-1 text-sm font-medium text-gray-500 md:ml-2">Edit Menutype</span>
                            </div>
                        </li>
                    </ol>
                </nav>


            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg p-6">
                <form action="{{ route('menu.update', $menu->id) }}" method="POST">
                    @csrf
                    @method("PUT")

                     {{-- Menutype --}}
                     <div class="mb-3">
                        <label class="block font-medium text-sm text-gray-700" for="menu_type_id">
                            Menutype
                        </label>
                        <select name="menu_type_id" autofocus=""
                            class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500  rounded-md shadow-sm">
                            @foreach ($menutypes as $menutype)
                                <option @if($menu->menu_type_id == $menutype->id) selected @endif value="{{$menutype->id}}">
                                    {{$menutype->name}}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="grid grid-cols-3 gap-2">

                        {{-- Day --}}
                        <div class="mb-3">
                            <label class="block font-medium text-sm text-gray-700" for="day">
                                Day
                            </label>
                            <select name="day" v-model="form.day"
                                class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500  rounded-md shadow-sm">
                                <option>Select Day</option>
                                <option value="1">Monday</option>
                                <option value="2">Tuesday</option>
                                <option value="3">Wednesday</option>
                                <option value="4">Thursday</option>
                                <option value="5">Friday</option>
                                <option value="6">Saturday</option>
                                <option value="7">Sunday</option>
                            </select>
                        </div>

                        {{-- Time From --}}
                        <div class="mb-3">
                            <label class="block font-medium text-sm text-gray-700" for="optiongroup">
                                Time From
                            </label>
                            <select name="from" v-model="form.time_from"
                                class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500  rounded-md shadow-sm">
                                <option>Select from</option>
                                <option value="00:00:00">12:00 am</option>
                                <option value="00:15:00">12:15 am</option>
                                <option value="00:30:00">12:30 am</option>
                                <option value="00:45:00">12:45 am</option>
                                <option value="01:00:00">01:00 am</option>
                                <option value="01:15:00">01:15 am</option>
                                <option value="01:30:00">01:30 am</option>
                                <option value="01:45:00">01:45 am</option>
                                <option value="02:00:00">02:00 am</option>
                                <option value="02:15:00">02:15 am</option>
                                <option value="02:30:00">02:30 am</option>
                                <option value="02:45:00">02:45 am</option>
                                <option value="03:00:00">03:00 am</option>
                                <option value="03:15:00">03:15 am</option>
                                <option value="03:30:00">03:30 am</option>
                                <option value="03:45:00">03:45 am</option>
                                <option value="04:00:00">04:00 am</option>
                                <option value="04:15:00">04:15 am</option>
                                <option value="04:30:00">04:30 am</option>
                                <option value="04:45:00">04:45 am</option>
                                <option value="05:00:00">05:00 am</option>
                                <option value="05:15:00">05:15 am</option>
                                <option value="05:30:00">05:30 am</option>
                                <option value="05:45:00">05:45 am</option>
                                <option value="06:00:00">06:00 am</option>
                                <option value="06:15:00">06:15 am</option>
                                <option value="06:30:00">06:30 am</option>
                                <option value="06:45:00">06:45 am</option>
                                <option value="07:00:00">07:00 am</option>
                                <option value="07:15:00">07:15 am</option>
                                <option value="07:30:00">07:30 am</option>
                                <option value="07:45:00">07:45 am</option>
                                <option value="08:00:00">08:00 am</option>
                                <option value="08:15:00">08:15 am</option>
                                <option value="08:30:00">08:30 am</option>
                                <option value="08:45:00">08:45 am</option>
                                <option value="09:00:00">09:00 am</option>
                                <option value="09:15:00">09:15 am</option>
                                <option value="09:30:00">09:30 am</option>
                                <option value="09:45:00">09:45 am</option>
                                <option value="10:00:00">10:00 am</option>
                                <option value="10:15:00">10:15 am</option>
                                <option value="10:30:00">10:30 am</option>
                                <option value="10:45:00">10:45 am</option>
                                <option value="11:00:00">11:00 am</option>
                                <option value="11:15:00">11:15 am</option>
                                <option value="11:30:00">11:30 am</option>
                                <option value="11:45:00">11:45 am</option>
                                <option value="12:00:00">12:00 pm</option>
                                <option value="12:15:00">12:15 pm</option>
                                <option value="12:30:00">12:30 pm</option>
                                <option value="12:45:00">12:45 pm</option>
                                <option value="13:00:00">01:00 pm</option>
                                <option value="13:15:00">01:15 pm</option>
                                <option value="13:30:00">01:30 pm</option>
                                <option value="13:45:00">01:45 pm</option>
                                <option value="14:00:00">02:00 pm</option>
                                <option value="14:15:00">02:15 pm</option>
                                <option value="14:30:00">02:30 pm</option>
                                <option value="14:45:00">02:45 pm</option>
                                <option value="15:00:00">03:00 pm</option>
                                <option value="15:15:00">03:15 pm</option>
                                <option value="15:30:00">03:30 pm</option>
                                <option value="15:45:00">03:45 pm</option>
                                <option value="16:00:00">04:00 pm</option>
                                <option value="16:15:00">04:15 pm</option>
                                <option value="16:30:00">04:30 pm</option>
                                <option value="16:45:00">04:45 pm</option>
                                <option value="17:00:00">05:00 pm</option>
                                <option value="17:15:00">05:15 pm</option>
                                <option value="17:30:00">05:30 pm</option>
                                <option value="17:45:00">05:45 pm</option>
                                <option value="18:00:00">06:00 pm</option>
                                <option value="18:15:00">06:15 pm</option>
                                <option value="18:30:00">06:30 pm</option>
                                <option value="18:45:00">06:45 pm</option>
                                <option value="19:00:00">07:00 pm</option>
                                <option value="19:15:00">07:15 pm</option>
                                <option value="19:30:00">07:30 pm</option>
                                <option value="19:45:00">07:45 pm</option>
                                <option value="20:00:00">08:00 pm</option>
                                <option value="20:15:00">08:15 pm</option>
                                <option value="20:30:00">08:30 pm</option>
                                <option value="20:45:00">08:45 pm</option>
                                <option value="21:00:00">09:00 pm</option>
                                <option value="21:15:00">09:15 pm</option>
                                <option value="21:30:00">09:30 pm</option>
                                <option value="21:45:00">09:45 pm</option>
                                <option value="22:00:00">10:00 pm</option>
                                <option value="22:15:00">10:15 pm</option>
                                <option value="22:30:00">10:30 pm</option>
                                <option value="22:45:00">10:45 pm</option>
                                <option value="23:00:00">11:00 pm</option>
                                <option value="23:15:00">11:15 pm</option>
                                <option value="23:30:00">11:30 pm</option>
                                <option value="23:45:00">11:45 pm</option>
                                <option value="23:59:00">11:59 pm</option>
                            </select>
                        </div>

                        {{-- Time To --}}
                        <div class="mb-3">
                            <label class="block font-medium text-sm text-gray-700" for="to">
                                Time To
                            </label>
                            <select name="to" v-model="form.time_to"
                                class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500  rounded-md shadow-sm">
                                <option>Select to</option>
                                <option value="00:00:00">12:00 am</option>
                                <option value="00:15:00">12:15 am</option>
                                <option value="00:30:00">12:30 am</option>
                                <option value="00:45:00">12:45 am</option>
                                <option value="01:00:00">01:00 am</option>
                                <option value="01:15:00">01:15 am</option>
                                <option value="01:30:00">01:30 am</option>
                                <option value="01:45:00">01:45 am</option>
                                <option value="02:00:00">02:00 am</option>
                                <option value="02:15:00">02:15 am</option>
                                <option value="02:30:00">02:30 am</option>
                                <option value="02:45:00">02:45 am</option>
                                <option value="03:00:00">03:00 am</option>
                                <option value="03:15:00">03:15 am</option>
                                <option value="03:30:00">03:30 am</option>
                                <option value="03:45:00">03:45 am</option>
                                <option value="04:00:00">04:00 am</option>
                                <option value="04:15:00">04:15 am</option>
                                <option value="04:30:00">04:30 am</option>
                                <option value="04:45:00">04:45 am</option>
                                <option value="05:00:00">05:00 am</option>
                                <option value="05:15:00">05:15 am</option>
                                <option value="05:30:00">05:30 am</option>
                                <option value="05:45:00">05:45 am</option>
                                <option value="06:00:00">06:00 am</option>
                                <option value="06:15:00">06:15 am</option>
                                <option value="06:30:00">06:30 am</option>
                                <option value="06:45:00">06:45 am</option>
                                <option value="07:00:00">07:00 am</option>
                                <option value="07:15:00">07:15 am</option>
                                <option value="07:30:00">07:30 am</option>
                                <option value="07:45:00">07:45 am</option>
                                <option value="08:00:00">08:00 am</option>
                                <option value="08:15:00">08:15 am</option>
                                <option value="08:30:00">08:30 am</option>
                                <option value="08:45:00">08:45 am</option>
                                <option value="09:00:00">09:00 am</option>
                                <option value="09:15:00">09:15 am</option>
                                <option value="09:30:00">09:30 am</option>
                                <option value="09:45:00">09:45 am</option>
                                <option value="10:00:00">10:00 am</option>
                                <option value="10:15:00">10:15 am</option>
                                <option value="10:30:00">10:30 am</option>
                                <option value="10:45:00">10:45 am</option>
                                <option value="11:00:00">11:00 am</option>
                                <option value="11:15:00">11:15 am</option>
                                <option value="11:30:00">11:30 am</option>
                                <option value="11:45:00">11:45 am</option>
                                <option value="12:00:00">12:00 pm</option>
                                <option value="12:15:00">12:15 pm</option>
                                <option value="12:30:00">12:30 pm</option>
                                <option value="12:45:00">12:45 pm</option>
                                <option value="13:00:00">01:00 pm</option>
                                <option value="13:15:00">01:15 pm</option>
                                <option value="13:30:00">01:30 pm</option>
                                <option value="13:45:00">01:45 pm</option>
                                <option value="14:00:00">02:00 pm</option>
                                <option value="14:15:00">02:15 pm</option>
                                <option value="14:30:00">02:30 pm</option>
                                <option value="14:45:00">02:45 pm</option>
                                <option value="15:00:00">03:00 pm</option>
                                <option value="15:15:00">03:15 pm</option>
                                <option value="15:30:00">03:30 pm</option>
                                <option value="15:45:00">03:45 pm</option>
                                <option value="16:00:00">04:00 pm</option>
                                <option value="16:15:00">04:15 pm</option>
                                <option value="16:30:00">04:30 pm</option>
                                <option value="16:45:00">04:45 pm</option>
                                <option value="17:00:00">05:00 pm</option>
                                <option value="17:15:00">05:15 pm</option>
                                <option value="17:30:00">05:30 pm</option>
                                <option value="17:45:00">05:45 pm</option>
                                <option value="18:00:00">06:00 pm</option>
                                <option value="18:15:00">06:15 pm</option>
                                <option value="18:30:00">06:30 pm</option>
                                <option value="18:45:00">06:45 pm</option>
                                <option value="19:00:00">07:00 pm</option>
                                <option value="19:15:00">07:15 pm</option>
                                <option value="19:30:00">07:30 pm</option>
                                <option value="19:45:00">07:45 pm</option>
                                <option value="20:00:00">08:00 pm</option>
                                <option value="20:15:00">08:15 pm</option>
                                <option value="20:30:00">08:30 pm</option>
                                <option value="20:45:00">08:45 pm</option>
                                <option value="21:00:00">09:00 pm</option>
                                <option value="21:15:00">09:15 pm</option>
                                <option value="21:30:00">09:30 pm</option>
                                <option value="21:45:00">09:45 pm</option>
                                <option value="22:00:00">10:00 pm</option>
                                <option value="22:15:00">10:15 pm</option>
                                <option value="22:30:00">10:30 pm</option>
                                <option value="22:45:00">10:45 pm</option>
                                <option value="23:00:00">11:00 pm</option>
                                <option value="23:15:00">11:15 pm</option>
                                <option value="23:30:00">11:30 pm</option>
                                <option value="23:45:00">11:45 pm</option>
                                <option value="23:59:00">11:59 pm</option>
                            </select>
                        </div>

                    </div>



                    <div class="mb-3">
                        <button type="submit"
                            class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 focus:bg-gray-700 active:bg-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150">
                            Submit
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    @push("scripts")
    <script src="https://unpkg.com/vue@3/dist/vue.global.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>

    <script>
      const { createApp, ref } = Vue

      createApp({
        data() {
            return {
                form: {
                    day: @json($menu->day),
                    time_from: @json($menu->from),
                    time_to: @json($menu->to)
                }
            }
        },
        created() {

        },
        methods: {

        },
      }).mount('#app')
    </script>
@endpush

</x-app-layout>
