<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Size') }}
        </h2>
    </x-slot>

    <div class="py-2">
      <div class="max-w-7xl mx-auto">

        
        <div class="flex justify-between items-center py-3">

          <nav class="flex" aria-label="Breadcrumb">
            <ol class="inline-flex items-center space-x-1 md:space-x-3">
              <li class="inline-flex items-center">
                <a href="/business-app/dashboard"
                  class="inline-flex items-center text-sm font-medium text-gray-700 hover:text-blue-600">
                  <svg class="w-3 h-3 mr-2.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor"
                    viewBox="0 0 20 20">
                    <path
                      d="m19.707 9.293-2-2-7-7a1 1 0 0 0-1.414 0l-7 7-2 2a1 1 0 0 0 1.414 1.414L2 10.414V18a2 2 0 0 0 2 2h3a1 1 0 0 0 1-1v-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v4a1 1 0 0 0 1 1h3a2 2 0 0 0 2-2v-7.586l.293.293a1 1 0 0 0 1.414-1.414Z">
                    </path>
                  </svg>
                  Home
                </a>
              </li>

              <li aria-current="page">
                <div class="flex items-center">
                  <svg class="w-3 h-3 text-gray-400 mx-1" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                    fill="none" viewBox="0 0 6 10">
                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                      d="m1 9 4-4-4-4"></path>
                  </svg>
                  <span class="ml-1 text-sm font-medium text-gray-500 md:ml-2">Sales</span>
                </div>
              </li>
            </ol>
          </nav>
          <!-- <a href="discount/create"
            class="bg-indigo-500 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded">
            <i class="fas fa-add"></i>
            Add Discount
          </a> -->
        </div>

        <div class="grid grid-cols-1 gap-4 md:grid-cols-2 md:gap-6 xl:grid-cols-4 2xl:gap-7.5 my-3">
          <!-- Card Item Start -->
          <div class="rounded-sm bg-white px-5 py-6 shadow-default">
            <div class="flex h-10 w-10 items-center justify-center rounded-full">
              <svg class="fill-primary dark:fill-white" width="22" height="16" viewBox="0 0 22 16" fill="#000" xmlns="http://www.w3.org/2000/svg">
                <path d="M11 15.1156C4.19376 15.1156 0.825012 8.61876 0.687512 8.34376C0.584387 8.13751 0.584387 7.86251 0.687512 7.65626C0.825012 7.38126 4.19376 0.918762 11 0.918762C17.8063 0.918762 21.175 7.38126 21.3125 7.65626C21.4156 7.86251 21.4156 8.13751 21.3125 8.34376C21.175 8.61876 17.8063 15.1156 11 15.1156ZM2.26876 8.00001C3.02501 9.27189 5.98126 13.5688 11 13.5688C16.0188 13.5688 18.975 9.27189 19.7313 8.00001C18.975 6.72814 16.0188 2.43126 11 2.43126C5.98126 2.43126 3.02501 6.72814 2.26876 8.00001Z" fill=""></path>
                <path d="M11 10.9219C9.38438 10.9219 8.07812 9.61562 8.07812 8C8.07812 6.38438 9.38438 5.07812 11 5.07812C12.6156 5.07812 13.9219 6.38438 13.9219 8C13.9219 9.61562 12.6156 10.9219 11 10.9219ZM11 6.625C10.2437 6.625 9.625 7.24375 9.625 8C9.625 8.75625 10.2437 9.375 11 9.375C11.7563 9.375 12.375 8.75625 12.375 8C12.375 7.24375 11.7563 6.625 11 6.625Z" fill=""></path>
              </svg>
            </div>

            <div class="mt-4 flex items-end justify-between">
              <div>
                <h4 class="text-title-md font-bold text-black dark:text-white">
                  ${{ $pending_balance }}
                </h4>
                <span class="text-sm font-medium">Pendind to Payouts</span>
              </div>

              <!-- <span class="flex items-center gap-1 text-sm font-medium text-meta-3">
                0.43%
                <svg width="10" height="11" viewBox="0 0 10 11" fill="#000" xmlns="http://www.w3.org/2000/svg">
                  <path d="M4.35716 2.47737L0.908974 5.82987L5.0443e-07 4.94612L5 0.0848689L10 4.94612L9.09103 5.82987L5.64284 2.47737L5.64284 10.0849L4.35716 10.0849L4.35716 2.47737Z" fill=""></path>
                </svg>
              </span> -->
            </div>
          </div>
          <!-- Card Item End -->

          <!-- Card Item Start -->
          <div class="rounded-sm bg-white px-5 py-6 shadow-default">
            <div class="flex h-10 w-10 items-center justify-center rounded-full">
              <svg class="fill-primary dark:fill-white" width="20" height="22" viewBox="0 0 20 22" fill="#000" xmlns="http://www.w3.org/2000/svg">
                <path d="M11.7531 16.4312C10.3781 16.4312 9.27808 17.5312 9.27808 18.9062C9.27808 20.2812 10.3781 21.3812 11.7531 21.3812C13.1281 21.3812 14.2281 20.2812 14.2281 18.9062C14.2281 17.5656 13.0937 16.4312 11.7531 16.4312ZM11.7531 19.8687C11.2375 19.8687 10.825 19.4562 10.825 18.9406C10.825 18.425 11.2375 18.0125 11.7531 18.0125C12.2687 18.0125 12.6812 18.425 12.6812 18.9406C12.6812 19.4219 12.2343 19.8687 11.7531 19.8687Z" fill=""></path>
                <path d="M5.22183 16.4312C3.84683 16.4312 2.74683 17.5312 2.74683 18.9062C2.74683 20.2812 3.84683 21.3812 5.22183 21.3812C6.59683 21.3812 7.69683 20.2812 7.69683 18.9062C7.69683 17.5656 6.56245 16.4312 5.22183 16.4312ZM5.22183 19.8687C4.7062 19.8687 4.2937 19.4562 4.2937 18.9406C4.2937 18.425 4.7062 18.0125 5.22183 18.0125C5.73745 18.0125 6.14995 18.425 6.14995 18.9406C6.14995 19.4219 5.73745 19.8687 5.22183 19.8687Z" fill=""></path>
                <path d="M19.0062 0.618744H17.15C16.325 0.618744 15.6031 1.23749 15.5 2.06249L14.95 6.01562H1.37185C1.0281 6.01562 0.684353 6.18749 0.443728 6.46249C0.237478 6.73749 0.134353 7.11562 0.237478 7.45937C0.237478 7.49374 0.237478 7.49374 0.237478 7.52812L2.36873 13.9562C2.50623 14.4375 2.9531 14.7812 3.46873 14.7812H12.9562C14.2281 14.7812 15.3281 13.8187 15.5 12.5469L16.9437 2.26874C16.9437 2.19999 17.0125 2.16562 17.0812 2.16562H18.9375C19.35 2.16562 19.7281 1.82187 19.7281 1.37499C19.7281 0.928119 19.4187 0.618744 19.0062 0.618744ZM14.0219 12.3062C13.9531 12.8219 13.5062 13.2 12.9906 13.2H3.7781L1.92185 7.56249H14.7094L14.0219 12.3062Z" fill=""></path>
              </svg>
            </div>

            <div class="mt-4 flex items-end justify-between">
              <div>
                <h4 class="text-title-md font-bold text-black dark:text-white">
                  ${{ $available_balance }}
                </h4>
                <span class="text-sm font-medium">Avaiable to Payouts</span>
              </div>

              <!-- <span class="flex items-center gap-1 text-sm font-medium text-meta-3">
                4.35%
                <svg width="10" height="11" viewBox="0 0 10 11" fill="#000" xmlns="http://www.w3.org/2000/svg">
                  <path d="M4.35716 2.47737L0.908974 5.82987L5.0443e-07 4.94612L5 0.0848689L10 4.94612L9.09103 5.82987L5.64284 2.47737L5.64284 10.0849L4.35716 10.0849L4.35716 2.47737Z" fill=""></path>
                </svg>
              </span> -->
            </div>
          </div>
          <!-- Card Item End -->

          <!-- Card Item Start -->
          <div class="rounded-sm bg-white px-5 py-6 shadow-default">
            <div class="flex h-10 w-10 items-center justify-center rounded-full">
              <svg class="fill-primary dark:fill-white" width="22" height="22" viewBox="0 0 22 22" fill="#000" xmlns="http://www.w3.org/2000/svg">
                <path d="M21.1063 18.0469L19.3875 3.23126C19.2157 1.71876 17.9438 0.584381 16.3969 0.584381H5.56878C4.05628 0.584381 2.78441 1.71876 2.57816 3.23126L0.859406 18.0469C0.756281 18.9063 1.03128 19.7313 1.61566 20.3844C2.20003 21.0375 2.99066 21.3813 3.85003 21.3813H18.1157C18.975 21.3813 19.8 21.0031 20.35 20.3844C20.9 19.7656 21.2094 18.9063 21.1063 18.0469ZM19.2157 19.3531C18.9407 19.6625 18.5625 19.8344 18.15 19.8344H3.85003C3.43753 19.8344 3.05941 19.6625 2.78441 19.3531C2.50941 19.0438 2.37191 18.6313 2.44066 18.2188L4.12503 3.43751C4.19378 2.71563 4.81253 2.16563 5.56878 2.16563H16.4313C17.1532 2.16563 17.7719 2.71563 17.875 3.43751L19.5938 18.2531C19.6282 18.6656 19.4907 19.0438 19.2157 19.3531Z" fill=""></path>
                <path d="M14.3345 5.29375C13.922 5.39688 13.647 5.80938 13.7501 6.22188C13.7845 6.42813 13.8189 6.63438 13.8189 6.80625C13.8189 8.35313 12.547 9.625 11.0001 9.625C9.45327 9.625 8.1814 8.35313 8.1814 6.80625C8.1814 6.6 8.21577 6.42813 8.25015 6.22188C8.35327 5.80938 8.07827 5.39688 7.66577 5.29375C7.25327 5.19063 6.84077 5.46563 6.73765 5.87813C6.6689 6.1875 6.63452 6.49688 6.63452 6.80625C6.63452 9.2125 8.5939 11.1719 11.0001 11.1719C13.4064 11.1719 15.3658 9.2125 15.3658 6.80625C15.3658 6.49688 15.3314 6.1875 15.2626 5.87813C15.1595 5.46563 14.747 5.225 14.3345 5.29375Z" fill=""></path>
              </svg>
            </div>

            <div class="mt-4 flex items-end justify-between">
              <div>
                <h4 class="text-title-md font-bold text-black dark:text-white">
                  2.450
                </h4>
                <span class="text-sm font-medium">E-Gift</span>
              </div>

              <!-- <span class="flex items-center gap-1 text-sm font-medium text-meta-3">
                2.59%
                <svg width="10" height="11" viewBox="0 0 10 11" fill="#000" xmlns="http://www.w3.org/2000/svg">
                  <path d="M4.35716 2.47737L0.908974 5.82987L5.0443e-07 4.94612L5 0.0848689L10 4.94612L9.09103 5.82987L5.64284 2.47737L5.64284 10.0849L4.35716 10.0849L4.35716 2.47737Z" fill=""></path>
                </svg>
              </span> -->
            </div>
          </div>
          <!-- Card Item End -->

          <!-- Card Item Start -->
          <div class="rounded-sm bg-white px-5 py-6 shadow-default">
            <div class="flex h-10 w-10 items-center justify-center rounded-full">
              <svg class="fill-primary dark:fill-white" width="22" height="18" viewBox="0 0 22 18" fill="#000" xmlns="http://www.w3.org/2000/svg">
                <path d="M7.18418 8.03751C9.31543 8.03751 11.0686 6.35313 11.0686 4.25626C11.0686 2.15938 9.31543 0.475006 7.18418 0.475006C5.05293 0.475006 3.2998 2.15938 3.2998 4.25626C3.2998 6.35313 5.05293 8.03751 7.18418 8.03751ZM7.18418 2.05626C8.45605 2.05626 9.52168 3.05313 9.52168 4.29063C9.52168 5.52813 8.49043 6.52501 7.18418 6.52501C5.87793 6.52501 4.84668 5.52813 4.84668 4.29063C4.84668 3.05313 5.9123 2.05626 7.18418 2.05626Z" fill=""></path>
                <path d="M15.8124 9.6875C17.6687 9.6875 19.1468 8.24375 19.1468 6.42188C19.1468 4.6 17.6343 3.15625 15.8124 3.15625C13.9905 3.15625 12.478 4.6 12.478 6.42188C12.478 8.24375 13.9905 9.6875 15.8124 9.6875ZM15.8124 4.7375C16.8093 4.7375 17.5999 5.49375 17.5999 6.45625C17.5999 7.41875 16.8093 8.175 15.8124 8.175C14.8155 8.175 14.0249 7.41875 14.0249 6.45625C14.0249 5.49375 14.8155 4.7375 15.8124 4.7375Z" fill=""></path>
                <path d="M15.9843 10.0313H15.6749C14.6437 10.0313 13.6468 10.3406 12.7874 10.8563C11.8593 9.61876 10.3812 8.79376 8.73115 8.79376H5.67178C2.85303 8.82814 0.618652 11.0625 0.618652 13.8469V16.3219C0.618652 16.975 1.13428 17.4906 1.7874 17.4906H20.2468C20.8999 17.4906 21.4499 16.9406 21.4499 16.2875V15.4625C21.4155 12.4719 18.9749 10.0313 15.9843 10.0313ZM2.16553 15.9438V13.8469C2.16553 11.9219 3.74678 10.3406 5.67178 10.3406H8.73115C10.6562 10.3406 12.2374 11.9219 12.2374 13.8469V15.9438H2.16553V15.9438ZM19.8687 15.9438H13.7499V13.8469C13.7499 13.2969 13.6468 12.7469 13.4749 12.2313C14.0937 11.7844 14.8499 11.5781 15.6405 11.5781H15.9499C18.0812 11.5781 19.8343 13.3313 19.8343 15.4625V15.9438H19.8687Z" fill=""></path>
              </svg>
            </div>

            <div class="mt-4 flex items-end justify-between">
              <div>
                <h4 class="text-title-md font-bold text-black dark:text-white">
                  {{ count($orders) }}
                </h4>
                <span class="text-sm font-medium">Online Product Order</span>
              </div>

              <!-- <span class="flex items-center gap-1 text-sm font-medium text-meta-5">
                0.95%
                <svg class="fill-meta-5" width="10" height="11" viewBox="0 0 10 11" fill="#000" xmlns="http://www.w3.org/2000/svg">
                  <path d="M5.64284 7.69237L9.09102 4.33987L10 5.22362L5 10.0849L-8.98488e-07 5.22362L0.908973 4.33987L4.35716 7.69237L4.35716 0.0848701L5.64284 0.0848704L5.64284 7.69237Z" fill=""></path>
                </svg>
              </span> -->
            </div>
          </div>
          <!-- Card Item End -->
        </div>




        <div class="bg-white overflow-hidden shadow-sm rounded-lg  mb-5">

          <div class="flex items-center justify-between bg-white px-4 py-5 sm:px-6">

            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                Sales
            </h2>
            <!-- <form action="/business-app/dashboard" method="GET" class="relative ms-auto text-gray-600">
              <input class="border-1 border-gray-300 bg-white h-10 px-5 pr-16 rounded-lg text-sm focus:outline-none"
                type="search" name="search" placeholder="Search" value="">
              <button type="submit" class="absolute right-0 top-0 mt-3 mr-4">
                <svg class="text-gray-600 h-4 w-4 fill-current" xmlns="http://www.w3.org/2000/svg"
                  xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px"
                  viewBox="0 0 56.966 56.966" style="enable-background:new 0 0 56.966 56.966;" xml:space="preserve"
                  width="512px" height="512px">
                  <path
                    d="M55.146,51.887L41.588,37.786c3.486-4.144,5.396-9.358,5.396-14.786c0-12.682-10.318-23-23-23s-23,10.318-23,23  s10.318,23,23,23c4.761,0,9.298-1.436,13.177-4.162l13.661,14.208c0.571,0.593,1.339,0.92,2.162,0.92  c0.779,0,1.518-0.297,2.079-0.837C56.255,54.982,56.293,53.08,55.146,51.887z M23.984,6c9.374,0,17,7.626,17,17s-7.626,17-17,17  s-17-7.626-17-17S14.61,6,23.984,6z">
                  </path>
                </svg>
              </button>
            </form> -->
          </div>
          <hr>
          <div class="relative overflow-x-auto px-3 pt-3">

            <table class="w-full text-left text-gray-600">
              <thead class="text-xs text-gray-700 uppercase bg-gray-50">
                <tr>
                  <th scope="col" class="px-4 py-3">
                    #
                  </th>
                  <th scope="col" class="px-4 py-3">
                    Company
                  </th>
                  <th scope="col" class="px-4 py-3">
                    Type
                  </th>
                  <th scope="col" class="px-4 py-3">
                    Status
                  </th>
                  <th scope="col" class="px-4 py-3 hidden sm:table-cell">
                    User
                  </th>
                  <th scope="col" class="px-4 py-3 hidden sm:table-cell">
                    Subtotal
                  </th>
                  <th scope="col" class="px-4 py-3 hidden sm:table-cell">
                    Tax
                  </th>
                  <th scope="col" class="px-4 py-3 hidden sm:table-cell">
                    Tips
                  </th>
                  <th scope="col" class="px-4 py-3 hidden sm:table-cell">
                    Discount
                  </th>
                  <th scope="col" class="px-4 py-3 hidden sm:table-cell">
                    Total
                  </th>
                  <th scope="col" class="px-4 py-3 hidden sm:table-cell">
                    Created At
                  </th>
                  <th>
                    Action
                  </th>
                </tr>
              </thead>
              <tbody>


                  @forelse ($orders as $order)
                  <tr class="bg-white border-b">
                    <td class="px-4 py-4">
                      {{ $loop->index + 1 }}
                    </td>
                    <td class="px-4 py-4">
                      {{ $order->company->name }}
                    </td>
                    <td class="px-4 py-4">
                      {{ $order->name }}
                    </td>
                    <td class="px-4 py-4 hidden sm:table-cell">
                      {{ $order->status }}
                    </td>
                    <td class="px-4 py-4 hidden sm:table-cell">
                      {{ $order->is_pause }}
                    </td>
                    <td class="px-4 py-4 hidden sm:table-cell">
                      {{ $order->subtotal }}
                    </td>
                    <td class="px-4 py-4 hidden sm:table-cell">
                      {{ $order->tax }}
                    </td>
                    <td class="px-4 py-4 hidden sm:table-cell">
                      {{ $order->tips }}
                    </td>
                    <td class="px-4 py-4 hidden sm:table-cell">
                      {{ $order->discount }}
                    </td>
                    <td class="px-4 py-4 hidden sm:table-cell">
                      {{ $order->total }}
                    </td>
                    <td class="px-4 py-4 hidden sm:table-cell">
                      {{ $order->created_at }}
                    </td>
                    <td>
                      <a class="inline-flex items-center p-2 bg-blue-600 hover:blue-red-700 text-white text-sm font-medium rounded-md mb-2"
                        href="">
                       
                        <svg class="h-4 w-4" fill="#ffffff" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 442.04 442.04" xml:space="preserve" stroke="#ffffff"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g> <g> <path d="M221.02,341.304c-49.708,0-103.206-19.44-154.71-56.22C27.808,257.59,4.044,230.351,3.051,229.203 c-4.068-4.697-4.068-11.669,0-16.367c0.993-1.146,24.756-28.387,63.259-55.881c51.505-36.777,105.003-56.219,154.71-56.219 c49.708,0,103.207,19.441,154.71,56.219c38.502,27.494,62.266,54.734,63.259,55.881c4.068,4.697,4.068,11.669,0,16.367 c-0.993,1.146-24.756,28.387-63.259,55.881C324.227,321.863,270.729,341.304,221.02,341.304z M29.638,221.021 c9.61,9.799,27.747,27.03,51.694,44.071c32.83,23.361,83.714,51.212,139.688,51.212s106.859-27.851,139.688-51.212 c23.944-17.038,42.082-34.271,51.694-44.071c-9.609-9.799-27.747-27.03-51.694-44.071 c-32.829-23.362-83.714-51.212-139.688-51.212s-106.858,27.85-139.688,51.212C57.388,193.988,39.25,211.219,29.638,221.021z"></path> </g> <g> <path d="M221.02,298.521c-42.734,0-77.5-34.767-77.5-77.5c0-42.733,34.766-77.5,77.5-77.5c18.794,0,36.924,6.814,51.048,19.188 c5.193,4.549,5.715,12.446,1.166,17.639c-4.549,5.193-12.447,5.714-17.639,1.166c-9.564-8.379-21.844-12.993-34.576-12.993 c-28.949,0-52.5,23.552-52.5,52.5s23.551,52.5,52.5,52.5c28.95,0,52.5-23.552,52.5-52.5c0-6.903,5.597-12.5,12.5-12.5 s12.5,5.597,12.5,12.5C298.521,263.754,263.754,298.521,221.02,298.521z"></path> </g> <g> <path d="M221.02,246.021c-13.785,0-25-11.215-25-25s11.215-25,25-25c13.786,0,25,11.215,25,25S234.806,246.021,221.02,246.021z"></path> </g> </g> </g></svg>
                      </a> 
                    </td>
                  </tr> 
                  @empty
                    <tr>
                      <td colspan="12" class="text-center pt-3">No Order Found</td>
                    </tr>
                  @endforelse
                
              

              </tbody>
            </table>

          </div>


          <div class="p-6">

          </div>

        </div>
      </div>
    </div>

</x-app-layout>
