<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }}</title>
    <link rel="stylesheet" href="{{ asset('assets/css/claim.css') }}" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=Rubik:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet" />

    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100;0,300;0,500;0,600;0,700;0,800;0,900;1,200;1,300;1,400;1,500;1,600;1,700;1,800&family=Rubik:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet" />
        <link rel="stylesheet" href="{{ asset('assets/css/bootstrap.css') }}">
        <link rel="stylesheet" href="{{ asset('assets/css/custom.css') }}">

    <style>
        .text-danger{
            color: #dc3545;
            text-align: left;
        }
        .text-small{
            font-size: 14px;
        }
        .sign-btn button:disabled {
            opacity: 0.7;
        }

        a{
            text-decoration: none;
        }
    </style>

    <!-- Scripts -->
    @vite(['resources/js/app.js'])

</head>

<body>
    <div class="cls form-new">
        <div class="main-signIn main-business">
            <div class="" id="app">
                <div class="container">
                    <div class="col-md-6 mx-auto">
                        <div class="bg-white p-5 radius-24">
                            <claim :company_id="{{ request('company_id') }}"></claim>   
                        </div>    
                    </div>    
                </div>             
            </div>
        </div>
        <div class="location-bar">
            <p class="greentag">
                Sample Thai: Bringing Healthy, Delicious Thai Cuisine and Expert Chefs
                from Thailand to Your Town.
            </p>
            <ul>
                <li><a href="" class="activeLoc">Olympia</a></li>
                <li><a href="">Tacoma</a></li>
                <li><a href="">Federal Way</a></li>
                <li><a href="">West Seattle</a></li>
                <li><a href="">Capital Hill</a></li>
                <li><a href="">Issaquah</a></li>
                <li><a href="">Kent</a></li>
                <li><a href="">North Seattle</a></li>
                <li><a href="">Bellevue</a></li>
                <li><a href="">Mercer-Island</a></li>
            </ul>
            <div class="bar-to" c>
                <img src="{{ asset('assets/svg/menu-bar.svg') }}" alt="" style="cursor: pointer"/>
            </div>
        </div>
        <div class="menu-items">
            <div class="menu-things container-width">
                <div class="side-menubar">
                    <h1 class="menuh1">Menu</h1>
                    <ul class="single-menu">
                        <li class="main-li click-open work-open">
                            <a class="unopen-tag" href="javascript:void(0)">Dinner</a>
                        </li>

                        <ul class="inner-ul">
                            <li class="bg-active-li">
                                <a href="javascript:void(0)">Starter</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Salad</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Soups</a>
                            </li>
                            <li class="to-active"><a href="javascript:void(0)">BBQ</a></li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Noodles</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Curry</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Fried Rice</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Entrees</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Special</a>
                            </li>
                        </ul>
                    </ul>
                    <ul class="single-menu">
                        <li class="click-open">
                            <a class="unopen-tag" href="javascript:void(0)">Lunch</a>
                        </li>
                        <ul class="inner-ul">
                            <li class="bg-active-li">
                                <a href="javascript:void(0)">Starter</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Salad</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Soups</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Noodles</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Curry</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Fried Rice</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Sea Food</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Special</a>
                            </li>
                        </ul>
                    </ul>
                    <ul class="single-menu">
                        <li class="click-open">
                            <a class="unopen-tag" href="javascript:void(0)">Happy Hours</a>
                        </li>
                        <ul class="inner-ul">
                            <li class="bg-active-li">
                                <a href="javascript:void(0)">Starter</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Salad</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Soups</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Noodles</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Curry</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Fried Rice</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Sea Food</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Special</a>
                            </li>
                        </ul>
                    </ul>
                    <ul class="single-menu">
                        <li class="click-open">
                            <a class="unopen-tag" href="javascript:void(0)">Late Night</a>
                        </li>
                        <ul class="inner-ul">
                            <li class="bg-active-li">
                                <a href="javascript:void(0)">Starter</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Salad</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Soups</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Noodles</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Curry</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Fried Rice</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Sea Food</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Special</a>
                            </li>
                        </ul>
                    </ul>
                    <ul class="single-menu">
                        <li class="click-open">
                            <a class="unopen-tag" href="javascript:void(0)">Kids Menu</a>
                        </li>
                        <ul class="inner-ul">
                            <li class="bg-active-li">
                                <a href="javascript:void(0)">Starter</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Salad</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Soups</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Noodles</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Curry</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Fried Rice</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Sea Food</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Special</a>
                            </li>
                        </ul>
                    </ul>
                    <ul class="single-menu">
                        <li class="click-open">
                            <a class="unopen-tag" href="javascript:void(0)">Vegan</a>
                        </li>
                        <ul class="inner-ul">
                            <li class="bg-active-li">
                                <a href="javascript:void(0)">Starter</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Salad</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Soups</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Noodles</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Curry</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Fried Rice</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Sea Food</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Special</a>
                            </li>
                        </ul>
                    </ul>
                    <ul class="single-menu">
                        <li class="click-open">
                            <a class="unopen-tag" href="javascript:void(0)">Drinks</a>
                        </li>
                        <ul class="inner-ul">
                            <li class="bg-active-li">
                                <a href="javascript:void(0)">Classic Sodas</a>
                            </li>
                            <li class="to-active"><a href="javascript:void(0)">Beer</a></li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Craft Beer</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Red and White Wine</a>
                            </li>
                        </ul>
                    </ul>
                    <ul class="single-menu">
                        <li class="click-open">
                            <a class="unopen-tag" href="javascript:void(0)">Happy Hours</a>
                        </li>
                        <ul class="inner-ul">
                            <li class="bg-active-li">
                                <a href="javascript:void(0)">Starter</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Salad</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Soups</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Noodles</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Curry</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Fried Rice</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Sea Food</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Special</a>
                            </li>
                        </ul>
                    </ul>
                    <ul class="single-menu">
                        <li class="click-open">
                            <a class="unopen-tag" href="javascript:void(0)">Late Night</a>
                        </li>
                        <ul class="inner-ul">
                            <li class="bg-active-li">
                                <a href="javascript:void(0)">Starter</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Salad</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Soups</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Noodles</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Curry</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Fried Rice</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Sea Food</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Special</a>
                            </li>
                        </ul>
                    </ul>
                    <ul class="single-menu">
                        <li class="click-open">
                            <a class="unopen-tag" href="javascript:void(0)">Kids Menu</a>
                        </li>
                        <ul class="inner-ul">
                            <li class="bg-active-li">
                                <a href="javascript:void(0)">Starter</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Salad</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Soups</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Noodles</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Curry</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Fried Rice</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Sea Food</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Special</a>
                            </li>
                        </ul>
                    </ul>
                    <ul class="single-menu">
                        <li class="click-open">
                            <a class="unopen-tag" href="javascript:void(0)">Vegan</a>
                        </li>
                        <ul class="inner-ul">
                            <li class="bg-active-li">
                                <a href="javascript:void(0)">Starter</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Salad</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Soups</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Noodles</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Curry</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Fried Rice</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Sea Food</a>
                            </li>
                            <li class="to-active">
                                <a href="javascript:void(0)">Special</a>
                            </li>
                        </ul>
                    </ul>
                </div>
                <div class="menu-content">
                    <h1 class="card-name">Starter</h1>
                    <div class="all-menucards">
                        <div class="flex-tcard">
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Miang Kum (Spice Level: Mild)</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Indulge in the flavors of Northern Thailand with our famous
                                    appetizer, Miang Kum. This delightful dish features betel
                                    leaves generously filled with a combination of dry shrimp,
                                    lime (skin on), gingers, fresh chilies, shallots, toasted
                                    coconut, toasted peanuts, and a drizzle of sweet and tangy
                                    sauce. Experience the perfect balance of savory, zesty, and
                                    crunchy elements that will leave your taste buds craving for
                                    more.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Chicken Lettuce Wrap:</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Experience the perfect harmony of flavors with our Stir
                                    Fried Ground Chicken. Prepared with ginger, garlic, and
                                    onion, this delectable dish is served with fresh lettuce
                                    wraps. Indulge in the combination of savory and crisp
                                    textures for a delightful culinary adventure.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>

                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Delicate Medley of Deep-Fried Vegetables</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Elevate your dining experience with our exquisite
                                    combination of hand-selected, crispy-fried onion, carrot,
                                    broccoli, and green beans. Expertly prepared and flawlessly
                                    presented, these delectable vegetables are accompanied by a
                                    refined peanut and chili sauce, adding a touch of
                                    sophistication to every bite. Indulge in this artfully
                                    crafted dish, where the textures and flavors are masterfully
                                    balanced for your refined palate.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Crab Wontons</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Crispy-fried wontons stuffed with a combination of crab,
                                    carrots, celery and cream cheese, served with Thai Sample
                                    mango sauce
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Fresh Rolls</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Stuffed with tofu or shrimp, BBQ pork, cilantro, bean
                                    sprouts, carrots, lettuce, basil leaves and rice vermicelli
                                    wrapped in soft rice skin. Served with our famous peanut
                                    sauce
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Crispy Taro Rolls</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Fried spring rolls stuffed with succulent shrimp and sweet
                                    taro, served with our house special plum sauce
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Spring Rolls</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Fried spring rolls stuffed with succulent vegetables, served
                                    with our house special plum sauce.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Chicken Satay</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Savory chicken marinated in yellow curry powder and coconut
                                    milk. Served with our homemade peanut sauce, cucumber salad,
                                    and toasted bread.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Chicken Wings</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Our tasty wings are marinated in garlic and soy sauce, then
                                    fried. Served with a sweet chili dipping sauce
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Lemongrass Wings</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Tasty wings are marinated in garlic, Lemongrass and soy
                                    sauce, then fried. Served with a sweet chili dipping sauce
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Thai Shrimp Cakes (Tod Mun Goong)</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Fried shrimp cakes, served with our house special plum plum
                                    sauce.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Mar Hor</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    A traditional Thai appetizer featuring ground chicken with
                                    palm sauce, peanuts and shallots served with skewered
                                    pineapple
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <h1 class="card-name tp-p">Salads</h1>
                    <div class="all-menucards">
                        <div class="flex-tcard">
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Green Papaya Salad (Som Tum)</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Papaya Thai salad featuring shredded papaya, tomatoes,
                                    carrots, green beans, fresh chilies, lime juice, dried
                                    shrimp and crushed peanuts.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Yum Salad</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Experience the perfect harmony of flavors with our Stir
                                    Fried Ground Chicken. Prepared with ginger, garlic, and
                                    onion, this delectable dish is served with fresh lettuce
                                    wraps. Indulge in the combination of savory and crisp
                                    textures for a delightful culinary adventure.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>

                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Larb</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    red onions, spring onions, cilantro, mint leaves, chili and
                                    ground toasted rice tossed in a zesty lime dressing. Served
                                    with fresh vegetables.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Crying Tiger ( Yum Neau Rare Beef Salad )</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>Fresh greens, tomatoes, onions, cucumber</p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Yum Talay</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Seafood salad with garlic,(Spice Level: Mild) A zesty salad
                                    tossed with cucumber, tomatoes, lettuce, red onions, spring
                                    onions, cilantro and a chili-lime dressing.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Yum Woon Sen</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Experience the vibrant flavors of our Yum Woon Sen salad.
                                    Crisp cabbage, carrot, celery, cilantro, and onions come
                                    together with your choice of tender chicken or succulent
                                    shrimps. Each bite is a delightful balance of fresh
                                    ingredients and savory goodness. Indulge in this refreshing
                                    and satisfying salad that will leave your taste buds
                                    tingling with delight.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <h1 class="card-name tp-p">BBQ</h1>
                    <div class="all-menucards">
                        <div class="flex-tcard">
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Thai Grilled Steak ( New York )</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Indulge in the succulent flavors of our Thai Grilled Steak.
                                    Tender New York steak is expertly grilled to perfection,
                                    creating a juicy and flavorful experience. Served alongside
                                    a vibrant herb medley and accompanied by a tantalizing Thai
                                    chili sauce, this dish promises to delight your taste buds.
                                    Complete your culinary journey by savoring the traditional
                                    Thai sticky rice, adding a delightful touch to this
                                    exceptional dining experience.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Thai-style Pork Ribs</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Experience the delectable flavors of our Thai-style pork
                                    ribs. These tender and flavorful ribs are marinated in our
                                    special blend of seasonings, creating a truly satisfying
                                    dish. Served alongside crisp broccoli and carrots, and
                                    accompanied by fragrant Thai sticky rice, this meal offers a
                                    delightful combination of taste and textures.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>

                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Thai Grilled Chicken</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Savor the succulent flavors of our marinated chicken,
                                    infused with aromatic curry powder, lemongrass, and black
                                    pepper. Expertly grilled to perfection, this tender chicken
                                    dish is served alongside a refreshing som tum salad. Indulge
                                    in the harmony of grilled goodness and zesty flavors for a
                                    truly satisfying dining experience.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Grilled Wild Salmon</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Delight in the exquisite flavors of our perfectly grilled
                                    wild salmon, cooked to tender perfection. Served alongside a
                                    medley of fresh asparagus, broccoli, and green beans, this
                                    dish offers a harmonious combination of flavors and
                                    textures. Accompanied by a side of fragrant rice, this meal
                                    is a true indulgence for seafood lovers.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Northern Thai Traditional Sausage</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Experience the authentic flavors of Northern Thailand with
                                    our traditional sausage. Made with a special blend of
                                    aromatic herbs and spices, this sausage is bursting with
                                    rich and savory flavors. Grilled to perfection, it is served
                                    with a side of sticky rice and a tangy dipping sauce,
                                    offering a taste of the region's culinary heritage.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <h1 class="card-name tp-p">Curries</h1>
                    <div class="all-menucards">
                        <div class="flex-tcard">
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Panang curry</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Pa-Nang curry pan-fried for a more concentrated flavor and
                                    aroma in coconut milk, bell peppers, basil and your choice
                                    of chicken, pork or tofu.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Red curry</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    A timeless Thai classic. This rich curry features red chili
                                    paste simmered with coconut milk, kaffir lime leaves, basil,
                                    bamboo shoots, and bell peppers.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>

                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Green curry</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Made with green chilies, our green curry emphasizes kafir
                                    lime peel and palm sugar. Simmered in coconut milk with
                                    bamboo shoots, basil, and bell peppers. Spicy. Gluten free.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Yellow curry</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Slightly milder than red or green curry, our yellow curry is
                                    cooked with coconut milk, potatoes, and onions. Spicy.
                                    Gluten free.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Mansaman curry</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    A mild southern-style curry of slowly simmered lamb rack,
                                    potatoes, peanuts and red onions cooked in massaman curry.
                                    This dish has peanuts as its main ingredient.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Jungle Curry</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Made with green chilies, our green curry emphasizes kaffir
                                    lime peel and palm sugar. Simmered in coconut milk with
                                    bamboo shoots, basil, and bell peppers, broccoli, carrot and
                                    tofu. Spicy. Gluten free.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Salmon curry</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Grilled Salmon filet atop jasmine rice, cucumber and our
                                    signature Panang Curry, which includes kaffir lime leaves
                                    and bell peppers. Topped with whipped cream, tobiko and
                                    kaffir lime leaf.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Pumpkin Curry</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    A timeless Thai classic. This rich curry features red chili
                                    paste simmered with coconut milk, kaffir lime leaves, basil,
                                    bamboo shoots, and bell peppers, pumpkin
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Curry Duck</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Succulent roasted duck immersed in a flavorful red curry
                                    sauce enriched with creamy coconut milk. Infused with the
                                    aromatic essence of kaffir lime leaves, fragrant basil,
                                    tender bamboo shoots, and vibrant bell peppers.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <h1 class="card-name tp-p">Noodles</h1>
                    <div class="all-menucards">
                        <div class="flex-tcard">
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Pad Thai</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Known as one of the most popular Thai noodle dishes, our
                                    version features stir-fried thin rice noodles mixed with a
                                    tangy tamarind sauce combined with egg, tofu, bean sprouts
                                    and ground peanuts.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Drunken Noodle</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Inspired by Thailand's countryside tastes, these stir-fried
                                    wide rice noodles are mixed with egg, fresh basil, bell
                                    peppers, broccoli, onions and tomatoes.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>

                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Pad sa ew</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Stir-fried wide rice noodles with tofu and fresh broccoli
                                    seasoned with flavorful soy sauce tossed in a hot wok.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Rad Nah</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Wide rice noodles stir-fried with crisp broccoli, carrots,
                                    and your choice of tender meat, all generously coated in a
                                    savory gravy sauce.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Pad Woon Sen</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    This classic Thai dish features glass noodles stir-fried
                                    with egg, onion, cabbage, carrot, and your choice of meat. A
                                    satisfying and flavorful option that highlights the unique
                                    texture of the glass noodles.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Rama Noodles</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    A delightful combination of wide rice noodles, spinach, and
                                    broccoli, generously topped with a rich and creamy peanut
                                    sauce. A harmonious blend of flavors and textures that will
                                    tantalize your taste buds.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Red Curry Noodles</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    A tantalizing combination of wide rice noodles, boiled eggs,
                                    and a rich red curry sauce. This dish showcases the perfect
                                    blend of flavors with the addition of bell peppers, bamboo
                                    shoots, and aromatic basil. Choose your preferred meat to
                                    create a memorable dining experience.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Yellow Curry Noodles</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Indulge in the delightful flavors of our Yellow Curry
                                    Noodles. Savor the aromatic yellow curry sauce that coats
                                    the wide rice noodles, along with tender meat of your
                                    choice. This dish features an array of vibrant ingredients,
                                    including bell peppers, bamboo shoots, fresh bean sprouts,
                                    and fragrant basil. Experience a harmonious balance of
                                    flavors and textures in every bite.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>MAMA PAD</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    A Noodle Sensation! Indulge in the delightful combination of
                                    Mama or egg noodles stir-fried to perfection. Tossed with
                                    crisp broccoli, snow peas, carrot, and onion, all coated in
                                    our tantalizing house special sauce. Experience the
                                    harmonious blend of flavors and textures that will satisfy
                                    your noodle cravings. Get ready to savor this delectable
                                    dish that will transport your taste buds to noodle paradise.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Ramen Drunken Noodles</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    A Fusion Delight! Indulge in our mouthwatering Ramen Drunken
                                    Noodles. Savor the perfect combination of ramen noodles,
                                    broccoli, onions, fresh basil, and bell peppers, expertly
                                    stir-fried in our signature drunken noodle sauce. The
                                    addition of juicy tomatoes adds a burst of flavor, elevating
                                    the dish to new heights. Prepare to be captivated by the
                                    harmonious medley of textures and aromas that will leave you
                                    craving for more.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Spaghetti Drunken Noodle</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    A Fusion Twist! Prepare to delight your taste buds with our
                                    unique Spaghetti Drunken Noodle. Enjoy the perfect blend of
                                    al dente spaghetti, broccoli, onions, fresh basil, and bell
                                    peppers, expertly stir-fried in our signature drunken noodle
                                    sauce. This fusion creation brings together the flavors of
                                    Thai and Italian cuisines, creating a tantalizing experience
                                    that will keep you coming back for more. Experience the
                                    magic of this culinary adventure with every satisfying bite.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Mee Krob Crunch</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Experience the delightful flavors of our Mee Krop dish.
                                    Crispy egg noodles take center stage, complemented by
                                    succulent meat, vibrant broccoli, and carrots. This
                                    tantalizing combination is enhanced by our special sauce,
                                    resulting in a satisfying crunch and a burst of savory
                                    goodness in every bite. Indulge in the irresistible allure
                                    of Mee Krop Crunch, a dish that promises to delight your
                                    palate.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Ba Mee</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Delight in the flavors of our Ba Mee dish. Savory BBQ pork
                                    is combined with egg noodles and a medley of fresh
                                    vegetables including broccoli, snow peas, onion, cabbage,
                                    carrot, and zucchini. Topped with a perfectly cooked egg,
                                    this dish offers a delightful combination of textures and
                                    flavors. Experience the deliciousness of Ba Mee at its
                                    finest.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Crispy Duck</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Indulge in the savory delight of our Crispy Duck dish. Enjoy
                                    succulent pieces of fried duck, perfectly crispy on the
                                    outside and tender on the inside. Served with a rich ginger
                                    sauce that adds a flavorful kick, this dish is accompanied
                                    by a bed of fresh spinach, providing a vibrant and
                                    nutritious complement. Please allow 20 minutes for this
                                    exquisite culinary creation to be prepared to perfection.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Khao Soi</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    The most famous Northern Thai dish, combines crispy and soft
                                    egg noodles, lime, pickled green mustard, sliced red onions
                                    and chicken thigh in a thin flavorful yellow curry.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Khao Soi Traditional</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Savor the authentic flavors of our Khao Soi Traditional
                                    dish. Ground pork simmered in a rich tomato sauce, combined
                                    with tender cabbage, onions, cilantro, and crisp bean
                                    sprouts, all served over wide rice noodles. This classic
                                    Northern E-sarn Thai delicacy offers a harmonious blend of
                                    textures and tastes, creating a truly memorable dining
                                    experience. Immerse yourself in the warm and comforting
                                    flavors of our Khao Soi Traditional, a dish that captures
                                    the essence of Thai cuisine.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <h1 class="card-name tp-p">Fried Rice</h1>
                    <div class="all-menucards">
                        <div class="flex-tcard">
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Pineapple Fried rice</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Jasmine rice infused with yellow curry flavor stir fried
                                    with pineapple, cashew nuts, tofu, raisins and onions.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Thai fried rice</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Jasmine rice stir-fried with egg, tomatoes and onions. Our
                                    Thai fried rice get its unique flavor from homemade secret
                                    sauce.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>

                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Brown fried rice</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Brown rice stir-fried with egg, tomatoes and onions. Our
                                    Thai fried rice get its unique flavor from homemade secret
                                    sauce.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Basil Fried Rice</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Experience the aromatic blend of flavors in our classic
                                    dish. Fragrant jasmine rice is stir-fried with onions, bell
                                    peppers, broccoli, and your choice of meat, all infused with
                                    the distinct taste of basil.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Chili sauce fried rice</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Indulge in the fiery flavors of our chili-infused fried
                                    rice. Fragrant jasmine rice is stir-fried with onions, bell
                                    peppers, broccoli, and your choice of meat, all coated in a
                                    tantalizing chili sauce for a spicy kick.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Tuna Fried Rice</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Savor the delicious combination of tender tuna, onions, and
                                    broccoli stir-fried with fragrant jasmine rice. This
                                    delightful dish brings together the flavors of the sea and
                                    fresh vegetables for a satisfying and wholesome meal.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Crab Fried Rice</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    A generous portion of succulent crab meat stir-fried with
                                    jasmine rice, egg, onions and tomatoes.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <h1 class="card-name tp-p">Entrees</h1>
                    <div class="all-menucards">
                        <div class="flex-tcard">
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Cashew Nut</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Tender chicken breast stir fried in our famous cashew nut
                                    sauce with red and green bell peppers, celery, carrots, red
                                    onions and cashew nuts.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Pad Krapao</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Choice of ground chicken or pork stir-fried with Thai basil,
                                    bell peppers, topped with fried egg then served over rice.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>

                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Ginger Chicken Stir-Fry</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Savor the bold flavors of our wok-fried dish featuring
                                    tender chicken, broccoli, onions, and mushrooms, all tossed
                                    in our special house sauce infused with ginger.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Wok-Fried Beef with Broccoli</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Enjoy the perfect harmony of tender beef and crisp broccoli,
                                    expertly wok-fried to perfection.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Mushroom Stir-Fry</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Savor the delectable combination of stir-fried mushrooms and
                                    onions, expertly cooked with your choice of meat in our
                                    flavorful house special gravy sauce.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <h1 class="card-name tp-p">Green bean</h1>
                    <div class="all-menucards">
                        <div class="flex-tcard">
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>(Spice Level: Medium)</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Stir-fried crisp green beans in a savory sauce of garlic and
                                    spicy dried shrimp paste with choice of meat.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Baby Corn Stir-Fry</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Delight in the flavors of tender baby corn stir-fried with
                                    your choice of meat, perfectly coated in our house special
                                    gravy sauce.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>

                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Mixed vegetables</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    A healthy combination of vegetables, tofu and Shiitake
                                    mushrooms tossed in our hot, seasoned wok for just the right
                                    color and crunch.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Crispy Garlic Chicken</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Our house specialty. Lightly battered and fried boneless
                                    chicken pieces, stir-fried in a sweet, garlic-infused sauce
                                    topped with crispy fried basil leaves and red bell peppers.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Garlic-Garlic</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    SA Garlic Lover's Delight! Immerse yourself in the
                                    irresistible flavors of garlic with our signature dish.
                                    Savor the perfect blend of stir-fried garlic sauce, crisp
                                    broccoli, carrot, cilantro, onion, and your choice of
                                    mouthwatering meat. Experience the tantalizing aroma and
                                    robust taste of garlic in every bite. Treat your taste buds
                                    to this exquisite culinary delight that will leave you
                                    craving for more.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Spicy Asian Eggplant Stir Fry</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Indulge in the bold and fiery flavors of our Spicy Asian
                                    Eggplant Stir Fry. Succulent Asian eggplant is stir-fried
                                    with bell peppers, basil, onions, and green beans, all
                                    bathed in a tantalizing chili sauce. The combination of heat
                                    and savory goodness will leave you craving for more. Served
                                    with your choice of meat, this dish is a true delight for
                                    spice lovers.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Pork Belly Gra Pao</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Indulge in the rich flavors of our Pork Belly Gra Pao dish.
                                    Succulent pieces of pork belly are stir-fried with aromatic
                                    Thai basil, bell pepper, onion, and mushroom, creating a
                                    mouthwatering medley of flavors. Topped with a perfectly
                                    fried egg, this dish is a delightful combination of textures
                                    and tastes that will leave you wanting more.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <h1 class="card-name tp-p">Chef's Special Signature</h1>
                    <div class="all-menucards">
                        <div class="flex-tcard">
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Tamarind Duck.</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Roasted duck in our delectable tamarind sauce, served on a
                                    bed of spinach, finished with crispy shallots.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Red Curry Roast Duck</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Roasted duck in traditional red curry with cherry tomatoes,
                                    bell peppers, Thai basil, grapes, fresh local pineapple and
                                    lychee.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>

                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Raging Seas</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    A tempestuous blend of lobster, squid, prawns, scallops, and
                                    mussels in a savory stir-fry. With crisp onions, bell
                                    peppers, fresh basil, and fiery chili paste, prepare for a
                                    wave of intense flavors that will leave you craving more.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Tom Yum Lobster</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Experience the vibrant flavors of our spicy-sour soup,
                                    featuring a succulent lobster tail, straw mushroom caps,
                                    lemongrass, galangal root, spring onions, and cilantro. It's
                                    a tantalizing delight for your taste buds.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Green Curry Beef (Flat Iron Steak)</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Grilled flat iron steak served sizzling in a hot stone bowl
                                    with aromatic green curry, kaffir lime leaves, Thai eggplant
                                    and Thai basil simmered in coconut milk.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Yellow Curry Crab</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Succulent Alaskan crab meat cooked with coconut milk and
                                    betel leaves simmered in an aromatic yellow curry.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Clay Pot Crab with Glass Noodles</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    A century old Thai favorite dish includes a combination of
                                    spiced crab, bacon, ginger, cilantro, white pepper on top of
                                    stir-fried glass noodles with our delicious homemade sauce.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Lemongrass Chicken</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Tender marinated chicken infused with curry powder,
                                    lemongrass, and black pepper. Topped with a delectable
                                    yellow curry sauce and served with a medley of crisp
                                    broccoli, cabbage, and carrots.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                            <div class="indiv-tcard">
                                <div class="nm-pc">
                                    <h4>Chili Garlic Seafood Asparagus</h4>
                                    <h4 class="greentheme">$50.00</h4>
                                </div>
                                <p>
                                    Experience the tantalizing combination of fresh asparagus
                                    and a medley of seafood, stir-fried to perfection in a spicy
                                    chili garlic sauce. Indulge in the vibrant flavors and
                                    textures of this exquisite dish, where the crispness of
                                    asparagus complements the succulent seafood for a delightful
                                    culinary adventure.
                                </p>
                                <div class="sign-btn bs-btn">
                                    <button>Add</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.0/jquery.min.js"></script>
    <script>
        let toggleDrop1 = () => {
            let drop1 = document.getElementById("drop1");
            // let overlayDrop = document.getElementById("overlayDrop");
            let parent = document.getElementById("parent");
            parent.classList.toggle("is-open");
            drop1.classList.toggle("show-it");
            // overlayDrop.classList.toggle("show-it");
        };
        let removedrop = () => {
            // let drop1 = document.getElementById("drop1");
            // // let overlayDrop = document.getElementById("overlayDrop");
            let parent = document.getElementById("parent");
            let drop2 = document.getElementById("drop2");
            // let parent2 = document.getElementById("parent2");
            parent.classList.remove("is-open");
            // drop1.classList.remove("show-it");
            // overlayDrop.classList.remove("show-it");

            // parent2.classList.remove("is-open");
            drop2.classList.remove("show-it");
            // overlayDrop.classList.remove("show-it");
        };

        let toggleDrop2 = () => {
            let drop2 = document.getElementById("drop2");
            // // let overlayDrop = document.getElementById("overlayDrop");
            let parent2 = document.getElementById("parent2");
            parent2.classList.toggle("is-open");
            drop2.classList.toggle("show-it");
            // overlayDrop.classList.toggle("show-it");
        };
        let toggleNav = () => {
            let max = document.getElementById("max");
            max.classList.toggle("max-height");
        };
        $(".link-option").hover(
            function() {
                $(this).addClass("active-link");
                $("#parent2").addClass("is-open");
            },
            function() {
                $(this).removeClass("active-link");
                $("#parent2").removeClass("is-open");
            }
        );
        $("#drop2").hover(
            function() {
                $(this).addClass("show-it");
            },
            function() {
                $(this).removeClass("show-it");
                $(".default-active").addClass("active-link");
            }
        );

        let valTotal = document.getElementById("valTotal");
        let maxNum = document.getElementById("maxNum");
        let discount = document.getElementById("discount");
        let totalAmount = document.getElementById("totalAmount");
        // maxNum.value = 10.0;
        $(document).ready(function() {
            $(".toggle-num").click(function() {
                $(".toggle-num").removeClass("bggreen");
                $(this).addClass("bggreen");
            });
        });
        let setSmall = () => {
            maxNum.value = 10;
            valTotal.innerHTML = "$" + 10 + ".00";
            discount.innerHTML = "$" + ((99 / 100) * maxNum.value).toFixed(2);
            totalAmount.innerHTML =
                "$" + (maxNum.value - (99 / 100) * maxNum.value).toFixed(2);
        };
        let setMed = () => {
            maxNum.value = 50;
            valTotal.innerHTML = "$" + 50 + ".00";
            discount.innerHTML = "$" + ((99 / 100) * maxNum.value).toFixed(2);
            totalAmount.innerHTML =
                "$" + (maxNum.value - (99 / 100) * maxNum.value).toFixed(2);
        };
        let setLarge = () => {
            maxNum.value = 300;
            valTotal.innerHTML = "$" + 300 + ".00";
            discount.innerHTML = "$" + ((99 / 100) * maxNum.value).toFixed(2);
            totalAmount.innerHTML =
                "$" + (maxNum.value - (99 / 100) * maxNum.value).toFixed(2);
        };
        let changeVal = () => {
            valTotal.innerHTML = "$" + maxNum.value + ".00";
            let val1 = document.getElementById("val1");
            let val2 = document.getElementById("val2");
            let val3 = document.getElementById("val3");
            if (maxNum.value == 10) {
                val1.classList.add("bggreen");
                val2.classList.remove("bggreen");
                console.log("Ok");
                val3.classList.remove("bggreen");
            } else if (maxNum.value == 50) {
                val1.classList.remove("bggreen");
                val2.classList.add("bggreen");
                val3.classList.remove("bggreen");
            } else if (maxNum.value == 300) {
                val2.classList.remove("bggreen");
                val1.classList.remove("bggreen");
                val3.classList.add("bggreen");
            } else {
                val2.classList.remove("bggreen");
                val1.classList.remove("bggreen");
                val3.classList.remove("bggreen");
            }
            if (maxNum.value === "") {
                valTotal.innerHTML = "$" + 0 + ".00";
            }
            discount.innerHTML = "$" + ((99 / 100) * maxNum.value).toFixed(2);
            totalAmount.innerHTML =
                "$" + (maxNum.value - (99 / 100) * maxNum.value).toFixed(2);
        };

        $(document).ready(function() {
            $(".mes").click(function() {
                $(".mes").removeClass("active_op");
                $(this).addClass("active_op");
            });
        });
        $(".bar-to").click(function() {
            $(".side-menubar").toggleClass("active-sideto");
            if (window.scrollY < 700) {
                $(".side-menubar").removeClass("active-sideto");
            }
        });

        window.addEventListener("scroll", function() {
            if (this.window.scrollY < 700) {
                $(".side-menubar").removeClass("active-sideto");
            }
            console.log(window.scrollY);
        });
    </script>

    <script>
        // let sidebar = document.getElementsByClassName("menu-things")[0];
        // let sidebar_content = document.getElementsByClassName("side-menubar")[0];
        // window.onscroll = () => {
        //   let scrollTop = window.scrollY; // current scroll position
        //   let viewportHeight = window.innerHeight; //viewport height
        //   let contentHeight = sidebar_content.getBoundingClientRect().height; // current content height
        //   let sidebarTop = sidebar.getBoundingClientRect().top + window.pageYOffset; //distance from top to sidebar
        //   if (scrollTop >= contentHeight - viewportHeight + sidebarTop)
        //     if (scrollTop >= contentHeight - viewportHeight + sidebarTop) {
        //       sidebar_content.style.transform = `translateY(-${
    //         contentHeight - viewportHeight + sidebarTop
    //       }px)`;
        //       sidebar_content.style.position = "fixed";
        //     } else {
        //       sidebar_content.style.transform = "";
        //       sidebar_content.style.position = "";
        //     }
        // };

        let toOpen = document.getElementsByClassName("click-open");

        for (let i = 0; i < toOpen.length; i++) {
            toOpen[i].addEventListener("click", function() {
                // element.classList.remove("work-open");

                // this.classList.add("work-open");
                var current = document.getElementsByClassName("work-open");
                current[0].className = current[0].className.replace(" work-open", "");
                this.className += " work-open";
            });
        }

        // for (var i = 0; i < btns.length; i++) {
        //   btns[i].addEventListener("click", function () {
        //     var current = document.getElementsByClassName("active");
        //     current[0].className = current[0].className.replace(" active", "");
        //     this.className += " active";
        //   });
        // }
        $(".to-active").click(function() {
            $(this).addClass("bg-active-li");
        });
    </script>

@livewireScripts

</body>

</html>
