<?php

use App\Http\Controllers\Api\V11\AppSettingController;
use App\Http\Controllers\Api\V11\AuthController;
use App\Http\Controllers\Api\V11\BusinessSettingController;
use App\Http\Controllers\Api\V11\CartController;
use App\Http\Controllers\Api\V11\CategoryController;
use App\Http\Controllers\Api\V11\CommonController;
use App\Http\Controllers\Api\V11\CompanyController;
use App\Http\Controllers\Api\V11\CompanyTypeController;
use App\Http\Controllers\Api\V11\DiscountController;
use App\Http\Controllers\Api\V11\EgiftConroller;
use App\Http\Controllers\Api\V11\EmployeeController;
use App\Http\Controllers\Api\V11\MenuController;
use App\Http\Controllers\Api\V11\MerchantController;
use App\Http\Controllers\Api\V11\OrderController;
use App\Http\Controllers\Api\V11\PayoutController;
use App\Http\Controllers\Api\V11\ProductController;
use App\Http\Controllers\Api\V11\ReportController;
use App\Http\Controllers\Api\V11\TipController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\V11\SalesController;
use App\Http\Controllers\Api\V11\UserController;
use Stripe\Order;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });

Route::any('/abc', function () {
    echo "abcd";
});

Route::group(["prefix" => "v1", "as" => "api."], function(){

    Route::get('menus/{company_id}', [MenuController::class, 'index']);
    Route::get('menu-types/{company_id}', [\App\Http\Controllers\Api\V11\MenuTypeController::class, 'menuTypes'])->where('company_id', '[0-9]+');

    Route::get('offers-left', [CommonController::class, 'offerLeft']);
    Route::get('user-profiles', [CommonController::class, 'userProfiles']);

    Route::get("facebook-reviews", [CommonController::class, 'facebookReviews']);

    Route::post("/sign-in", [UserController::class, 'sign_in']);
    //get employee by key
    Route::get('employee-by-key/{company}/{employee:key}', [EmployeeController::class, 'getemployeebykey']);
    Route::get('companies/{employee:key}/check-in', [EmployeeController::class, 'clockin']);
    Route::get('companies/{employee:key}/check-out', [EmployeeController::class, 'clockout']);
    Route::get('company-orders/{company}', [OrderController::class, 'companyOrders'])->middleware("auth:sanctum");
    Route::post('employees/subtotal', [OrderController::class, 'enterSubtotal'])->middleware('auth:sanctum');
    Route::post('add-product-to-order', [OrderController::class, 'addProductToOrder'])->middleware('auth:sanctum');
    Route::post('add-custom-product-to-order', [OrderController::class, 'addCustomProductToOrder'])->middleware('auth:sanctum');
    Route::post('send-order-verification-otp', [OrderController::class, 'sendOrderVerificationOtp'])->middleware('auth:sanctum');
    Route::get('user-by-barcode', [UserController::class, 'getUserByBarcode']);


    Route::get('google/company-list', [CompanyController::class,'nearByCompanies']);
    Route::post("get-or-create-google-company", [MerchantController::class, 'getOrCreateGoogleCompany']);
    Route::get('company-list', [CompanyController::class,'index']);
    Route::get('company-menu-types', [CompanyTypeController::class,'companyMenuTypes']);
    Route::get('company-types', [CompanyTypeController::class,'index']);
    Route::post("merchant-signup", [MerchantController::class, 'store']);
    Route::post("company-update/{company_id}", [MerchantController::class, 'update']);
    Route::post("save-business-settings", [BusinessSettingController::class, 'store']);
    Route::post("stripe-connect", [CompanyController::class, 'startOnBoarding']);

    Route::post("resend-otp/{phone_number}", [AuthController::class, 'sendOtp']);
    Route::post("claim/{company_id}", [AuthController::class, 'claim']);
    Route::post("redeem", [AuthController::class, 'redeem']);
    Route::post('customer-signup', [AuthController::class, 'customerSignup']);

    Route::get("company-categories/{company_id}", [CategoryController::class, 'categoryList']);
    Route::get('company-products/{company_id}', [ProductController::class, 'productList']);
    Route::get("company-details/{company_id}", [CompanyController::class, 'companyDetails']);
    Route::get("google/company-details/{company_id}", [CompanyController::class, 'nearByCompanyDetails']);
    Route::get("company-discount/{company_id}", [DiscountController::class, 'companyDiscount']);
    Route::get('global-discounts', [DiscountController::class, 'globalDiscounts']);
    Route::post("buy-global-discount", [DiscountController::class, 'buyGlobalDiscount']);
    Route::post("buy-discount", [DiscountController::class, 'buyDiscount']);

    Route::get('user-details', [AuthController::class, 'userDetails'])->middleware("auth:sanctum");
    Route::get('order-details/{order_id}', [OrderController::class, 'orderDetails']);
    Route::get('order-company-details/{order_id}', [OrderController::class, 'orderCompanyDetails']);
    Route::post('pay-now', [OrderController::class, 'payNow'])->middleware("auth:sanctum");
    Route::post('pay-by-global-gift', [OrderController::class, 'payByGlobalGift'])->middleware("auth:sanctum");

    Route::get('company-tips/{company_id}', [TipController::class, 'companyTips']);
    Route::get('get-carts', [CartController::class, 'getAllCart']);
    Route::get('get-cart', [CartController::class, 'getMyCart']);
    Route::get('product-list/{company_id}', [\App\Http\Controllers\Api\V11\ProductController::class, 'companyProductList']);
    Route::get('product/{product_id}', [\App\Http\Controllers\Api\V11\ProductController::class, 'singleProduct']);
    Route::post('add-to-cart', [\App\Http\Controllers\Api\V11\CartController::class, 'myAddtoCart']);
    Route::post('update-cart', [\App\Http\Controllers\Api\V11\CartController::class, 'updateMyCart']);

    Route::get('location-address',[AuthController::class, 'userLocationAddress']);
    Route::get('address-to-coords',[AuthController::class, 'addressToCoords']);

    Route::group(['middleware' => 'auth:sanctum'], function () {

        // Route::get('companies/{company}/table-list', [TableController::class, 'tableList']);
        // Route::get('companies/{company}/product-list', [ProductController::class, 'productList']);

        // author:salim
        // company categories with image
        Route::get('category-list/{company_id}', [\App\Http\Controllers\Api\V11\CategoryController::class, 'categoryList']);

        Route::get('product-variations/{product_id}', [\App\Http\Controllers\Api\V11\ProductController::class, 'productVariations']);

        Route::post('reserve-table', [\App\Http\Controllers\Api\V11\ReservationController::class, 'reserveTable']);
        Route::post('assign-table', [\App\Http\Controllers\Api\V11\ReservationController::class, 'assignTableToReservation']);
        Route::get('reserved-tables/{company_id}', [\App\Http\Controllers\Api\V11\ReservationController::class, 'reservedTables']);
        Route::get('active-reservation', [\App\Http\Controllers\Api\V11\ReservationController::class, 'activeReservation']);
        Route::get('table-list/{company_id}', [\App\Http\Controllers\Api\V11\ReservationController::class, 'tableList']);

        Route::post('employee-place-order', [\App\Http\Controllers\Api\V11\OrderController::class, 'employeePlaceOrder']);
        Route::post('customer-place-order', [\App\Http\Controllers\Api\V11\OrderController::class, 'saveCustomerOrder']);

        Route::post('claim-discount', [\App\Http\Controllers\Api\V11\ClaimController::class, 'claimDiscount']);

        Route::get('customer-stripe-infos', [AuthController::class, 'stripeInfos']);
        Route::post('buy-egift', [EgiftConroller::class, 'buy']);

        Route::get('egift-details/{id}', [EgiftConroller::class, 'egiftDetails']);
        Route::post('confirm-egift', [EgiftConroller::class, 'confirmEgift']);

        Route::get("customer-orders", [OrderController::class, 'customerOrders']);

        Route::get("/sales", [SalesController::class, 'index']);

        Route::get("/payout-balance", [PayoutController::class, 'payoutBalance']);

        Route::get('user-by-phone', [UserController::class, 'getUserByPhone']);

        Route::get('stripe-connected-accounts', [CompanyController::class, 'stripeConnectedAccounts']);
    });

});
