<?php

use App\Http\Controllers\Api\V1\Company\CompanyController as CompanyCompanyController;
use App\Models\CompanyType;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\BusinessApp\AreaController;
use App\Http\Controllers\BusinessApp\MenuController;
use App\Http\Controllers\BusinessApp\SizeController;
use App\Http\Controllers\BusinessApp\TableController;
use App\Http\Controllers\BusinessApp\OptionController;
use App\Http\Controllers\BusinessApp\RewardController;
use App\Http\Controllers\BusinessApp\CompanyController;
use App\Http\Controllers\BusinessApp\ProductController;
use App\Http\Controllers\BusinessApp\CategoryController;
use App\Http\Controllers\BusinessApp\DiscountController;
use App\Http\Controllers\BusinessApp\DashboardController;
use App\Http\Controllers\BusinessApp\EmployessController;
use App\Http\Controllers\BusinessApp\MenuTypeController;
use App\Http\Controllers\BusinessApp\OptionGroupController;
use App\Http\Controllers\BusinessApp\TipController;
use App\Http\Controllers\BusinessApp\TaxController;
use App\Http\Controllers\BusinessApp\PromoController;
use App\Http\Controllers\BusinessApp\StripePayoutController;
use App\Http\Controllers\BusinessApp\StripePayoutRefreshController;
use App\Http\Controllers\BusinessApp\RegularGiftCardController;
use App\Http\Controllers\BusinessApp\ReportController;
use App\Http\Controllers\BusinessApp\SalesController;
use Illuminate\Support\Facades\Auth;

// Route::get('/logout', [Laravel\Fortify\Http\Controllers\AuthenticatedSessionController::class, 'destroy'])->name('fortify-logout');
// Auth::routes(['verify' => false]);
// Route::get('/claim-discount', [CompanyCompanyController::class, 'claimDiscount']);
// Route::get('/table/order-payment/{table_id}', [TableController::class, 'table_order'])->name('table-order-payment');


Route::middleware([
    'auth:sanctum',
])->prefix('/dashboard')->group(function () {


    Route::get('/', [DashboardController::class, 'index'])->name('dashboard')->middleware('verified');

    Route::group(['middleware' => 'CheckIfUserHasCompany'], function () {

        // Stripe Payout
        Route::get('/payout', [StripePayoutController::class, 'index'])->name('payout');
        Route::get('/report', [ReportController::class, 'index'])->name('report');
        // Route::get('/sales', [SalesController::class, 'index'])->name('sales');
        Route::get('/sales-data', [SalesController::class, 'getSalesData'])->name('sales-data');
        Route::get('/sale-details/{id}', [SalesController::class, 'saleDetails'])->name('sale-details');
        Route::get('/refund-sale-order/{id}', [SalesController::class, 'refundSaleOrder'])->name('refund-sale-order');
        Route::post('/make-refund-sale-order/{id}', [SalesController::class, 'makeRefund'])->name('save-refund-sale-order');
        Route::get('/our_backup_database', [SalesController::class, 'our_backup_database'])->name('our_backup_database');


        Route::get('/stripe_payout_refresh', [StripePayoutRefreshController::class, 'refresh']);
        Route::get('/stripe_payout_return', function () {
            return view('business-app.stripe-onboard-success'); // replace 'stripe_payout_return' with the name of your view file
        });

        Route::get('/business-setting', [DiscountController::class, 'businessSetting'])->name('businessSetting');
        // Stripe Payout
        Route::get('/payout', [StripePayoutController::class, 'index'])->name('payout');
        Route::get('/stripe_payout_refresh', [StripePayoutRefreshController::class, 'refresh']);
        Route::get('/stripe_payout_return', function () {
            return view('business-app.stripe-onboard-success'); // replace 'stripe_payout_return' with the name of your view file
        });

        // Route::get('/sales', [DiscountController::class, 'index'])->name('sales');

        // Route::get('/discount', [DiscountController::class, 'index'])->name('discount');
        // Route::get('/create-discount', [DiscountController::class, 'createaftersignup'])->name('discount-aftersignup');
        
        //company
        Route::get('/company/{id}', [CompanyController::class, 'index'])->name('company');
        Route::post('/company-settings', [CompanyController::class, 'updateSettings'])->name('company.settings.update');
        Route::get('/company-terms/{id}', [CompanyController::class, 'terms'])->name('company-terms');
        Route::post('/company-add-phone/{id}', [CompanyController::class, 'addPhone'])->name('company-add-phone');
        Route::post('/company-send-otp/{id}', [CompanyController::class, 'sendOTP'])->name('company-send-otp');
        Route::post('/company-verify-otp/{id}', [CompanyController::class, 'verifyOtp'])->name('company-verify-otp');

        Route::get('/company-image', [DashboardController::class, 'image'])->name('companyimage');
        Route::post('/upload-company-logo', [DashboardController::class, 'uploadLogo'])->name('company.logo.upload');
        Route::post('/upload-company-cover', [DashboardController::class, 'uploadCoverImage'])->name('company.cover.upload');
        Route::post('/upload-company-banner', [DashboardController::class, 'uploadBannerImage'])->name('company.banner.upload');
        Route::post('/upload-dashboard-setting', [DashboardController::class, 'updateDashboardSetting'])->name('company.dashboard.update');


        //employees
        Route::resource('employees', EmployessController::class);
        Route::get('/employeelog/{employee}', [EmployessController::class, 'employeelog'])->name('employeelog');
        Route::get('/employee/{employee}/area', [EmployessController::class, 'addemployeeArea'])->name('addemployeeArea');

        //Tip
        Route::resource('tip', TipController::class);

        //Tax
        Route::resource('tax', TaxController::class);

        Route::get('/regulat-gift', [RegularGiftCardController::class, 'index'])->name('regular.gift');

        //promo
        Route::get('/claim', [PromoController::class, 'index'])->name('claim');

        //area
        Route::resource('area', AreaController::class);

        // Route::get('/create-area', [AreaController::class, 'createaftersignup'])->name('areaaftersignup');

        //menu
        // Route::get('/menu-type', [MenuController::class, 'type'])->name('menutype');
        // Route::get('/menu', [MenuController::class, 'menu'])->name('menu');
        // Route::get('/create-menu', [MenuController::class, 'createaftersignup'])->name('menuaftersignup');
        Route::resource('menu', MenuController::class);
        Route::resource('menu-type', MenuTypeController::class);

        //size
        // Route::get('/size', [SizeController::class, 'index'])->name('size');
        Route::resource('size', SizeController::class);
        //options
        // Route::get('/option-group', [OptionController::class, 'optiongroup'])->name('optiongroup');
        // Route::get('/option', [OptionController::class, 'option'])->name('option');
        Route::resource('option-group', OptionGroupController::class);
        Route::resource('option', OptionController::class);

        //table
        // Route::get('/table', [TableController::class, 'index'])->name('table');
        // Route::get('/create-table', [TableController::class, 'createaftersignup'])->name('tableaftersignup');
        Route::resource('table', TableController::class);

        //reward
        Route::get('/reward', [RewardController::class, 'index'])->name('reward');

        //product
        // Route::get( '/product', [ProductController::class, 'index'])->name('product');
        // Route::post('/product/submit', [ProductController::class, 'store'])->name('product.store');
        // Route::get( '/product/{id}', [ProductController::class, 'show'])->name('product.get');
        // Route::get( '/product/delete/{id}', [ProductController::class, 'delete'])->name('product.delete');
        Route::resource('product', ProductController::class);

        //category
        // Route::get('/category', [CategoryController::class, 'index'])->name('category');
        // Route::get('/category/{category}/sub-category', [CategoryController::class, 'subcategory'])->name('subcategory');
        // Route::get('/category/{category}/sub-category/{subcategory}', [CategoryController::class, 'secondsubcategory'])->name('secondsubcategory');
        Route::resource('category', CategoryController::class);

        Route::resource('sales', SalesController::class);

        Route::resource('discount', DiscountController::class);
    });

});

// Route::get('/', [DashboardController::class, 'index'])->name('business-dashboard');

// Route::get('/sign-up', function () {
//     $company_type = CompanyType::all();
//     return view('business-app.auth.register', compact('company_type'));
// })->name('business-signup');

// Route::get('/login', function () {
//     return view('business-app.auth.login');
// })->name('business-login');




// Route::get('/test', function () {
//     return view('test');
// });

// Route::get('/imageupload', [DashboardController::class, 'imageupload']);
// Route::post('/imageupload', [DashboardController::class, 'testimageupload'])->name('imageupload');
// Route::post('/bannerupload', [DashboardController::class, 'bannerimageupload'])->name('bannerupload');


// // Route::get('/submit', function () {
// //     dd("fuction called for image");
// // })->name('image');

// Route::get('/get-s3-document', function () {

//     $image = Storage::disk('spaces')->get('https://sfo3.digitaloceanspaces.com/dev.pickgo.com/public/5b56d894-defa-400d-bf2e-7bac1682c83d');
//     dd($image);


//     return view('test');
// });
