<?php

use App\Http\Controllers\GuestController;
use App\Http\Controllers\MyCompanyController;
use App\Http\Controllers\ProfileController;
use App\Models\CompanyType;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });

// Route::get('/dashboard', function () {
//     return view('dashboard');
// })->middleware(['auth', 'verified'])->name('dashboard');

// Author: Salim Hosen
Route::get('table-reservation/{company_id}', [MyCompanyController::class, 'reserveTable'])->name('table.reservation');
Route::post('reserve-table', [MyCompanyController::class, 'saveReserveTable'])->name('table.reserve');
Route::post('cancel-reservation', [MyCompanyController::class, 'cancelReservation'])->name('reservation.cancel');

Route::get('temp-business', [GuestController::class, 'tempBusiness'])->name("temp.list");

Route::get("mes", function(){

    dd(session()->all());
});

Route::get('sitepass', function(){
    $password = request()->password ?: session('sitepass', null);
    if($password == 'tony'){
        session()->put("sitepass", "tony");
        return Redirect::to('/');
    }
    return view("sitepass");
})->name("sitepass");


Route::get('/app', [HomeController::class, 'app'])->name('download.app');
// Route::get('page/offers/{company_id}', [GuestController::class, 'claim'])->name('claim');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';


Route::view('add-card', "add-card")->name("add.card");

Route::post('save-card-data', [MyOrderController::class, 'saveCardData'])->name("savecarddata")->middleware("auth:sanctum");


Route::get('business-hours/{company_id}', [\App\Http\Controllers\Api\V11\CompanyController::class, 'businessHours'])->name("webapi.businesshours");
Route::post('customer-signup', [\App\Http\Controllers\Api\V11\AuthController::class, 'customerSignup'])->name("webapi.customer.signup");
Route::post('customer-signin', [\App\Http\Controllers\Api\V11\AuthController::class, 'customerSignin'])->name("webapi.customer.signin");
Route::post('/add-card', [\App\Http\Controllers\Api\V11\AuthController::class, 'addCard'])->name("webapi.customer.addcard");
Route::post('/save-card', [\App\Http\Controllers\Api\V11\AuthController::class, 'saveCard'])->name("webapi.customer.savecard");

// Route::get('company-discounts', [\App\Http\Controllers\Api\V11\CompanyController::class, 'getCompanyDiscounts'])->name("webapi.company.discounts");
Route::get('company-discount/{id}', [\App\Http\Controllers\Api\V11\CompanyController::class, 'getCompanyDiscount'])->name("webapi.company.discount");
Route::post('create-company-discount', [\App\Http\Controllers\Api\V11\CompanyController::class, 'createCompanyDiscount'])->name("webapi.company.discount.create");
Route::put('update-company-discount/{id}', [\App\Http\Controllers\Api\V11\CompanyController::class, 'updateCompanyDiscount'])->name("webapi.company.discount.update");
// Route::delete('delete-company-discount/{id}', [\App\Http\Controllers\Api\V11\CompanyController::class, 'deleteCompanyDiscount'])->name("webapi.company.discount.delete");

Route::get('/merchant-app/{any}', function () {
    return view('merchant-app.dashboard');
})->where('any', '.*');


Route::get('/{any}', function () {
    return view('vue');
})->where('any', '.*');


// ALTER TABLE `products` ADD `option_type` VARCHAR(20) NULL AFTER `menu_type_id`;


// ALTER TABLE `user_global_discounts` ADD `redeem_code` VARCHAR(255) NULL AFTER `credit_amount`, ADD `qr_code` VARCHAR(255) NULL AFTER `redeem_code`, ADD `info_data` VARCHAR(255) NULL AFTER `qr_code`;

// 1. Still many issues on the admin app side can't say they're 100% correctly or not on egift applying are really correct until order 
// creation is correct. Because when you fix or changes things in order creating then you may forget about egift again.  
// So need to clear order creating first on app. 
// 2. On app, order status: active order only lists on main page. 
// 3. Some items not able to add order
// 4. Item options not able to create or add
// 5. Enter otp not working 

// 1. Places and businesses creation. 
// 2 order creation. 
// 3 gift creation. 
// 4 use and calculation. Today at least update me above design, countdown and 
// 1. Places and business creation